/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.UnionDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class DateOrEpochMillis
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<DateOrEpochMillis> _DESERIALIZER = JsonpDeserializer.lazy(DateOrEpochMillis::buildDateOrEpochMillisDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private DateOrEpochMillis(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    public String _toJsonString() {
        switch (this._kind) {
            case Date: {
                return this.date();
            }
            case Millis: {
                return String.valueOf(this.millis());
            }
        }
        throw new IllegalStateException("Unknown kind " + (Object)((Object)this._kind));
    }

    private DateOrEpochMillis(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static DateOrEpochMillis of(Function<Builder, ObjectBuilder<DateOrEpochMillis>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isDate() {
        return this._kind == Kind.Date;
    }

    public String date() {
        return (String)TaggedUnionUtils.get(this, Kind.Date);
    }

    public boolean isMillis() {
        return this._kind == Kind.Millis;
    }

    public Long millis() {
        return (Long)TaggedUnionUtils.get(this, Kind.Millis);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Date: {
                    generator.write((String)this._value);
                    break;
                }
                case Millis: {
                    generator.write(((Long)this._value).longValue());
                }
            }
        }
    }

    private static JsonpDeserializer<DateOrEpochMillis> buildDateOrEpochMillisDeserializer() {
        return new UnionDeserializer.Builder<DateOrEpochMillis, Kind, Object>(DateOrEpochMillis::new, false).addMember(Kind.Date, JsonpDeserializer.stringDeserializer()).addMember(Kind.Millis, JsonpDeserializer.longDeserializer()).build();
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DateOrEpochMillis> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<DateOrEpochMillis> date(String v) {
            this._kind = Kind.Date;
            this._value = v;
            return this;
        }

        public ObjectBuilder<DateOrEpochMillis> millis(Long v) {
            this._kind = Kind.Millis;
            this._value = v;
            return this;
        }

        @Override
        public DateOrEpochMillis build() {
            this._checkSingleUse();
            return new DateOrEpochMillis(this);
        }
    }

    public static enum Kind {
        Date,
        Millis;

    }
}

