/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.elasticsearch.transform.SyncVariant;
import co.elastic.clients.elasticsearch.transform.TimeSync;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Sync
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<Sync> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Sync::setupSyncDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public Sync(SyncVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._syncKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private Sync(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static Sync of(Function<Builder, ObjectBuilder<Sync>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isTime() {
        return this._kind == Kind.Time;
    }

    public TimeSync time() {
        return (TimeSync)TaggedUnionUtils.get(this, Kind.Time);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupSyncDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::time, TimeSync._DESERIALIZER, "time");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Sync> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<Sync> time(TimeSync v) {
            this._kind = Kind.Time;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Sync> time(Function<TimeSync.Builder, ObjectBuilder<TimeSync>> fn) {
            return this.time(fn.apply(new TimeSync.Builder()).build());
        }

        @Override
        public Sync build() {
            this._checkSingleUse();
            return new Sync(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Time("time");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

