/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class TotalFeatureImportanceStatistics
implements JsonpSerializable {
    private final double meanMagnitude;
    private final int max;
    private final int min;
    public static final JsonpDeserializer<TotalFeatureImportanceStatistics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TotalFeatureImportanceStatistics::setupTotalFeatureImportanceStatisticsDeserializer);

    private TotalFeatureImportanceStatistics(Builder builder) {
        this.meanMagnitude = ApiTypeHelper.requireNonNull(builder.meanMagnitude, this, "meanMagnitude");
        this.max = ApiTypeHelper.requireNonNull(builder.max, this, "max");
        this.min = ApiTypeHelper.requireNonNull(builder.min, this, "min");
    }

    public static TotalFeatureImportanceStatistics of(Function<Builder, ObjectBuilder<TotalFeatureImportanceStatistics>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final double meanMagnitude() {
        return this.meanMagnitude;
    }

    public final int max() {
        return this.max;
    }

    public final int min() {
        return this.min;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("mean_magnitude");
        generator.write(this.meanMagnitude);
        generator.writeKey("max");
        generator.write(this.max);
        generator.writeKey("min");
        generator.write(this.min);
    }

    protected static void setupTotalFeatureImportanceStatisticsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::meanMagnitude, JsonpDeserializer.doubleDeserializer(), "mean_magnitude");
        op.add(Builder::max, JsonpDeserializer.integerDeserializer(), "max");
        op.add(Builder::min, JsonpDeserializer.integerDeserializer(), "min");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<TotalFeatureImportanceStatistics> {
        private Double meanMagnitude;
        private Integer max;
        private Integer min;

        public final Builder meanMagnitude(double value) {
            this.meanMagnitude = value;
            return this;
        }

        public final Builder max(int value) {
            this.max = value;
            return this;
        }

        public final Builder min(int value) {
            this.min = value;
            return this;
        }

        @Override
        public TotalFeatureImportanceStatistics build() {
            this._checkSingleUse();
            return new TotalFeatureImportanceStatistics(this);
        }
    }
}

