/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.Conflicts;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.SearchType;
import co.elastic.clients.elasticsearch._types.SlicedScroll;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.WaitForActiveShards;
import co.elastic.clients.elasticsearch._types.query_dsl.Operator;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.DeleteByQueryResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DeleteByQueryRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final Boolean analyzeWildcard;
    @Nullable
    private final String analyzer;
    @Nullable
    private final Conflicts conflicts;
    @Nullable
    private final Operator defaultOperator;
    @Nullable
    private final String df;
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final Long from;
    @Nullable
    private final Boolean ignoreUnavailable;
    private final List<String> index;
    @Nullable
    private final Boolean lenient;
    @Nullable
    private final Long maxDocs;
    @Nullable
    private final String preference;
    @Nullable
    private final String q;
    @Nullable
    private final Query query;
    @Nullable
    private final Boolean refresh;
    @Nullable
    private final Boolean requestCache;
    @Nullable
    private final Long requestsPerSecond;
    @Nullable
    private final String routing;
    @Nullable
    private final Time scroll;
    @Nullable
    private final Long scrollSize;
    @Nullable
    private final Time searchTimeout;
    @Nullable
    private final SearchType searchType;
    @Nullable
    private final SlicedScroll slice;
    @Nullable
    private final Long slices;
    private final List<String> sort;
    private final List<String> stats;
    @Nullable
    private final Long terminateAfter;
    @Nullable
    private final Time timeout;
    @Nullable
    private final Boolean version;
    @Nullable
    private final WaitForActiveShards waitForActiveShards;
    @Nullable
    private final Boolean waitForCompletion;
    public static final JsonpDeserializer<DeleteByQueryRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DeleteByQueryRequest::setupDeleteByQueryRequestDeserializer);
    public static final Endpoint<DeleteByQueryRequest, DeleteByQueryResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<DeleteByQueryRequest, DeleteByQueryResponse>("es/delete_by_query", request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_delete_by_query");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.slices != null) {
            params.put("slices", String.valueOf(request.slices));
        }
        if (request.df != null) {
            params.put("df", request.df);
        }
        if (request.terminateAfter != null) {
            params.put("terminate_after", String.valueOf(request.terminateAfter));
        }
        if (request.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(request.waitForCompletion));
        }
        if (request.lenient != null) {
            params.put("lenient", String.valueOf(request.lenient));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.requestsPerSecond != null) {
            params.put("requests_per_second", String.valueOf(request.requestsPerSecond));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (ApiTypeHelper.isDefined(request.stats)) {
            params.put("stats", request.stats.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.analyzer != null) {
            params.put("analyzer", request.analyzer);
        }
        if (request.conflicts != null) {
            params.put("conflicts", request.conflicts.jsonValue());
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (ApiTypeHelper.isDefined(request.expandWildcards)) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.preference != null) {
            params.put("preference", request.preference);
        }
        if (request.searchTimeout != null) {
            params.put("search_timeout", request.searchTimeout._toJsonString());
        }
        if (request.analyzeWildcard != null) {
            params.put("analyze_wildcard", String.valueOf(request.analyzeWildcard));
        }
        if (request.scroll != null) {
            params.put("scroll", request.scroll._toJsonString());
        }
        if (request.scrollSize != null) {
            params.put("scroll_size", String.valueOf(request.scrollSize));
        }
        if (request.refresh != null) {
            params.put("refresh", String.valueOf(request.refresh));
        }
        if (ApiTypeHelper.isDefined(request.sort)) {
            params.put("sort", request.sort.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.searchType != null) {
            params.put("search_type", request.searchType.jsonValue());
        }
        if (request.version != null) {
            params.put("version", String.valueOf(request.version));
        }
        if (request.q != null) {
            params.put("q", request.q);
        }
        if (request.defaultOperator != null) {
            params.put("default_operator", request.defaultOperator.jsonValue());
        }
        if (request.waitForActiveShards != null) {
            params.put("wait_for_active_shards", request.waitForActiveShards._toJsonString());
        }
        if (request.requestCache != null) {
            params.put("request_cache", String.valueOf(request.requestCache));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, DeleteByQueryResponse._DESERIALIZER);

    private DeleteByQueryRequest(Builder builder) {
        this.allowNoIndices = builder.allowNoIndices;
        this.analyzeWildcard = builder.analyzeWildcard;
        this.analyzer = builder.analyzer;
        this.conflicts = builder.conflicts;
        this.defaultOperator = builder.defaultOperator;
        this.df = builder.df;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.from = builder.from;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.index = ApiTypeHelper.unmodifiableRequired(builder.index, (Object)this, "index");
        this.lenient = builder.lenient;
        this.maxDocs = builder.maxDocs;
        this.preference = builder.preference;
        this.q = builder.q;
        this.query = builder.query;
        this.refresh = builder.refresh;
        this.requestCache = builder.requestCache;
        this.requestsPerSecond = builder.requestsPerSecond;
        this.routing = builder.routing;
        this.scroll = builder.scroll;
        this.scrollSize = builder.scrollSize;
        this.searchTimeout = builder.searchTimeout;
        this.searchType = builder.searchType;
        this.slice = builder.slice;
        this.slices = builder.slices;
        this.sort = ApiTypeHelper.unmodifiable(builder.sort);
        this.stats = ApiTypeHelper.unmodifiable(builder.stats);
        this.terminateAfter = builder.terminateAfter;
        this.timeout = builder.timeout;
        this.version = builder.version;
        this.waitForActiveShards = builder.waitForActiveShards;
        this.waitForCompletion = builder.waitForCompletion;
    }

    public static DeleteByQueryRequest of(Function<Builder, ObjectBuilder<DeleteByQueryRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public final Boolean analyzeWildcard() {
        return this.analyzeWildcard;
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public final Conflicts conflicts() {
        return this.conflicts;
    }

    @Nullable
    public final Operator defaultOperator() {
        return this.defaultOperator;
    }

    @Nullable
    public final String df() {
        return this.df;
    }

    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final Long from() {
        return this.from;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final Boolean lenient() {
        return this.lenient;
    }

    @Nullable
    public final Long maxDocs() {
        return this.maxDocs;
    }

    @Nullable
    public final String preference() {
        return this.preference;
    }

    @Nullable
    public final String q() {
        return this.q;
    }

    @Nullable
    public final Query query() {
        return this.query;
    }

    @Nullable
    public final Boolean refresh() {
        return this.refresh;
    }

    @Nullable
    public final Boolean requestCache() {
        return this.requestCache;
    }

    @Nullable
    public final Long requestsPerSecond() {
        return this.requestsPerSecond;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final Time scroll() {
        return this.scroll;
    }

    @Nullable
    public final Long scrollSize() {
        return this.scrollSize;
    }

    @Nullable
    public final Time searchTimeout() {
        return this.searchTimeout;
    }

    @Nullable
    public final SearchType searchType() {
        return this.searchType;
    }

    @Nullable
    public final SlicedScroll slice() {
        return this.slice;
    }

    @Nullable
    public final Long slices() {
        return this.slices;
    }

    public final List<String> sort() {
        return this.sort;
    }

    public final List<String> stats() {
        return this.stats;
    }

    @Nullable
    public final Long terminateAfter() {
        return this.terminateAfter;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final Boolean version() {
        return this.version;
    }

    @Nullable
    public final WaitForActiveShards waitForActiveShards() {
        return this.waitForActiveShards;
    }

    @Nullable
    public final Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.maxDocs != null) {
            generator.writeKey("max_docs");
            generator.write(this.maxDocs.longValue());
        }
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (this.slice != null) {
            generator.writeKey("slice");
            this.slice.serialize(generator, mapper);
        }
    }

    protected static void setupDeleteByQueryRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxDocs, JsonpDeserializer.longDeserializer(), "max_docs");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::slice, SlicedScroll._DESERIALIZER, "slice");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DeleteByQueryRequest> {
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private Boolean analyzeWildcard;
        @Nullable
        private String analyzer;
        @Nullable
        private Conflicts conflicts;
        @Nullable
        private Operator defaultOperator;
        @Nullable
        private String df;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private Long from;
        @Nullable
        private Boolean ignoreUnavailable;
        private List<String> index;
        @Nullable
        private Boolean lenient;
        @Nullable
        private Long maxDocs;
        @Nullable
        private String preference;
        @Nullable
        private String q;
        @Nullable
        private Query query;
        @Nullable
        private Boolean refresh;
        @Nullable
        private Boolean requestCache;
        @Nullable
        private Long requestsPerSecond;
        @Nullable
        private String routing;
        @Nullable
        private Time scroll;
        @Nullable
        private Long scrollSize;
        @Nullable
        private Time searchTimeout;
        @Nullable
        private SearchType searchType;
        @Nullable
        private SlicedScroll slice;
        @Nullable
        private Long slices;
        @Nullable
        private List<String> sort;
        @Nullable
        private List<String> stats;
        @Nullable
        private Long terminateAfter;
        @Nullable
        private Time timeout;
        @Nullable
        private Boolean version;
        @Nullable
        private WaitForActiveShards waitForActiveShards;
        @Nullable
        private Boolean waitForCompletion;

        public final Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public final Builder analyzeWildcard(@Nullable Boolean value) {
            this.analyzeWildcard = value;
            return this;
        }

        public final Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public final Builder conflicts(@Nullable Conflicts value) {
            this.conflicts = value;
            return this;
        }

        public final Builder defaultOperator(@Nullable Operator value) {
            this.defaultOperator = value;
            return this;
        }

        public final Builder df(@Nullable String value) {
            this.df = value;
            return this;
        }

        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        public final Builder from(@Nullable Long value) {
            this.from = value;
            return this;
        }

        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder lenient(@Nullable Boolean value) {
            this.lenient = value;
            return this;
        }

        public final Builder maxDocs(@Nullable Long value) {
            this.maxDocs = value;
            return this;
        }

        public final Builder preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        public final Builder q(@Nullable String value) {
            this.q = value;
            return this;
        }

        public final Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public final Builder refresh(@Nullable Boolean value) {
            this.refresh = value;
            return this;
        }

        public final Builder requestCache(@Nullable Boolean value) {
            this.requestCache = value;
            return this;
        }

        public final Builder requestsPerSecond(@Nullable Long value) {
            this.requestsPerSecond = value;
            return this;
        }

        public final Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public final Builder scroll(@Nullable Time value) {
            this.scroll = value;
            return this;
        }

        public final Builder scroll(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.scroll(fn.apply(new Time.Builder()).build());
        }

        public final Builder scrollSize(@Nullable Long value) {
            this.scrollSize = value;
            return this;
        }

        public final Builder searchTimeout(@Nullable Time value) {
            this.searchTimeout = value;
            return this;
        }

        public final Builder searchTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.searchTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder searchType(@Nullable SearchType value) {
            this.searchType = value;
            return this;
        }

        public final Builder slice(@Nullable SlicedScroll value) {
            this.slice = value;
            return this;
        }

        public final Builder slice(Function<SlicedScroll.Builder, ObjectBuilder<SlicedScroll>> fn) {
            return this.slice(fn.apply(new SlicedScroll.Builder()).build());
        }

        public final Builder slices(@Nullable Long value) {
            this.slices = value;
            return this;
        }

        public final Builder sort(List<String> list) {
            this.sort = Builder._listAddAll(this.sort, list);
            return this;
        }

        public final Builder sort(String value, String ... values) {
            this.sort = Builder._listAdd(this.sort, value, values);
            return this;
        }

        public final Builder stats(List<String> list) {
            this.stats = Builder._listAddAll(this.stats, list);
            return this;
        }

        public final Builder stats(String value, String ... values) {
            this.stats = Builder._listAdd(this.stats, value, values);
            return this;
        }

        public final Builder terminateAfter(@Nullable Long value) {
            this.terminateAfter = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder version(@Nullable Boolean value) {
            this.version = value;
            return this;
        }

        public final Builder waitForActiveShards(@Nullable WaitForActiveShards value) {
            this.waitForActiveShards = value;
            return this;
        }

        public final Builder waitForActiveShards(Function<WaitForActiveShards.Builder, ObjectBuilder<WaitForActiveShards>> fn) {
            return this.waitForActiveShards(fn.apply(new WaitForActiveShards.Builder()).build());
        }

        public final Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        @Override
        public DeleteByQueryRequest build() {
            this._checkSingleUse();
            return new DeleteByQueryRequest(this);
        }
    }
}

