/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.UnionDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class BucketsPath
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<BucketsPath> _DESERIALIZER = JsonpDeserializer.lazy(BucketsPath::buildBucketsPathDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private BucketsPath(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private BucketsPath(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static BucketsPath of(Function<Builder, ObjectBuilder<BucketsPath>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isArray() {
        return this._kind == Kind.Array;
    }

    public List<String> array() {
        return (List)TaggedUnionUtils.get(this, Kind.Array);
    }

    public boolean isDict() {
        return this._kind == Kind.Dict;
    }

    public Map<String, String> dict() {
        return (Map)TaggedUnionUtils.get(this, Kind.Dict);
    }

    public boolean isSingle() {
        return this._kind == Kind.Single;
    }

    public String single() {
        return (String)TaggedUnionUtils.get(this, Kind.Single);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Array: {
                    generator.writeStartArray();
                    for (String item0 : (List)this._value) {
                        generator.write(item0);
                    }
                    generator.writeEnd();
                    break;
                }
                case Dict: {
                    generator.writeStartObject();
                    for (Map.Entry item0 : ((Map)this._value).entrySet()) {
                        generator.writeKey((String)item0.getKey());
                        generator.write((String)item0.getValue());
                    }
                    generator.writeEnd();
                    break;
                }
                case Single: {
                    generator.write((String)this._value);
                }
            }
        }
    }

    private static JsonpDeserializer<BucketsPath> buildBucketsPathDeserializer() {
        return new UnionDeserializer.Builder<BucketsPath, Kind, Object>(BucketsPath::new, false).addMember(Kind.Array, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())).addMember(Kind.Dict, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer())).addMember(Kind.Single, JsonpDeserializer.stringDeserializer()).build();
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<BucketsPath> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<BucketsPath> array(List<String> v) {
            this._kind = Kind.Array;
            this._value = v;
            return this;
        }

        public ObjectBuilder<BucketsPath> dict(Map<String, String> v) {
            this._kind = Kind.Dict;
            this._value = v;
            return this;
        }

        public ObjectBuilder<BucketsPath> single(String v) {
            this._kind = Kind.Single;
            this._value = v;
            return this;
        }

        @Override
        public BucketsPath build() {
            this._checkSingleUse();
            return new BucketsPath(this);
        }
    }

    public static enum Kind {
        Array,
        Dict,
        Single;

    }
}

