/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch._types.NodeRole;
import co.elastic.clients.elasticsearch.indices.stats.IndexStats;
import co.elastic.clients.elasticsearch.nodes.AdaptiveSelection;
import co.elastic.clients.elasticsearch.nodes.Breaker;
import co.elastic.clients.elasticsearch.nodes.FileSystem;
import co.elastic.clients.elasticsearch.nodes.Http;
import co.elastic.clients.elasticsearch.nodes.Ingest;
import co.elastic.clients.elasticsearch.nodes.Jvm;
import co.elastic.clients.elasticsearch.nodes.OperatingSystem;
import co.elastic.clients.elasticsearch.nodes.Process;
import co.elastic.clients.elasticsearch.nodes.Scripting;
import co.elastic.clients.elasticsearch.nodes.ThreadCount;
import co.elastic.clients.elasticsearch.nodes.Transport;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class Stats
implements JsonpSerializable {
    private final Map<String, AdaptiveSelection> adaptiveSelection;
    private final Map<String, Breaker> breakers;
    private final FileSystem fs;
    private final String host;
    private final Http http;
    private final IndexStats indices;
    private final Ingest ingest;
    private final List<String> ip;
    private final Jvm jvm;
    private final String name;
    private final OperatingSystem os;
    private final Process process;
    private final List<NodeRole> roles;
    private final Scripting script;
    private final Map<String, ThreadCount> threadPool;
    private final long timestamp;
    private final Transport transport;
    private final String transportAddress;
    private final Map<String, String> attributes;
    public static final JsonpDeserializer<Stats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Stats::setupStatsDeserializer);

    private Stats(Builder builder) {
        this.adaptiveSelection = ApiTypeHelper.unmodifiableRequired(builder.adaptiveSelection, (Object)this, "adaptiveSelection");
        this.breakers = ApiTypeHelper.unmodifiableRequired(builder.breakers, (Object)this, "breakers");
        this.fs = ApiTypeHelper.requireNonNull(builder.fs, this, "fs");
        this.host = ApiTypeHelper.requireNonNull(builder.host, this, "host");
        this.http = ApiTypeHelper.requireNonNull(builder.http, this, "http");
        this.indices = ApiTypeHelper.requireNonNull(builder.indices, this, "indices");
        this.ingest = ApiTypeHelper.requireNonNull(builder.ingest, this, "ingest");
        this.ip = ApiTypeHelper.unmodifiableRequired(builder.ip, (Object)this, "ip");
        this.jvm = ApiTypeHelper.requireNonNull(builder.jvm, this, "jvm");
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.os = ApiTypeHelper.requireNonNull(builder.os, this, "os");
        this.process = ApiTypeHelper.requireNonNull(builder.process, this, "process");
        this.roles = ApiTypeHelper.unmodifiableRequired(builder.roles, (Object)this, "roles");
        this.script = ApiTypeHelper.requireNonNull(builder.script, this, "script");
        this.threadPool = ApiTypeHelper.unmodifiableRequired(builder.threadPool, (Object)this, "threadPool");
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, this, "timestamp");
        this.transport = ApiTypeHelper.requireNonNull(builder.transport, this, "transport");
        this.transportAddress = ApiTypeHelper.requireNonNull(builder.transportAddress, this, "transportAddress");
        this.attributes = ApiTypeHelper.unmodifiableRequired(builder.attributes, (Object)this, "attributes");
    }

    public static Stats of(Function<Builder, ObjectBuilder<Stats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, AdaptiveSelection> adaptiveSelection() {
        return this.adaptiveSelection;
    }

    public final Map<String, Breaker> breakers() {
        return this.breakers;
    }

    public final FileSystem fs() {
        return this.fs;
    }

    public final String host() {
        return this.host;
    }

    public final Http http() {
        return this.http;
    }

    public final IndexStats indices() {
        return this.indices;
    }

    public final Ingest ingest() {
        return this.ingest;
    }

    public final List<String> ip() {
        return this.ip;
    }

    public final Jvm jvm() {
        return this.jvm;
    }

    public final String name() {
        return this.name;
    }

    public final OperatingSystem os() {
        return this.os;
    }

    public final Process process() {
        return this.process;
    }

    public final List<NodeRole> roles() {
        return this.roles;
    }

    public final Scripting script() {
        return this.script;
    }

    public final Map<String, ThreadCount> threadPool() {
        return this.threadPool;
    }

    public final long timestamp() {
        return this.timestamp;
    }

    public final Transport transport() {
        return this.transport;
    }

    public final String transportAddress() {
        return this.transportAddress;
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.adaptiveSelection)) {
            generator.writeKey("adaptive_selection");
            generator.writeStartObject();
            for (Map.Entry<String, AdaptiveSelection> entry : this.adaptiveSelection.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.breakers)) {
            generator.writeKey("breakers");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.breakers.entrySet()) {
                generator.writeKey(entry.getKey());
                ((Breaker)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("fs");
        this.fs.serialize(generator, mapper);
        generator.writeKey("host");
        generator.write(this.host);
        generator.writeKey("http");
        this.http.serialize(generator, mapper);
        generator.writeKey("indices");
        this.indices.serialize(generator, mapper);
        generator.writeKey("ingest");
        this.ingest.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.ip)) {
            generator.writeKey("ip");
            generator.writeStartArray();
            for (String string : this.ip) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        generator.writeKey("jvm");
        this.jvm.serialize(generator, mapper);
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("os");
        this.os.serialize(generator, mapper);
        generator.writeKey("process");
        this.process.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (NodeRole nodeRole : this.roles) {
                nodeRole.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("script");
        this.script.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.threadPool)) {
            generator.writeKey("thread_pool");
            generator.writeStartObject();
            for (Map.Entry entry : this.threadPool.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((ThreadCount)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
        generator.writeKey("transport");
        this.transport.serialize(generator, mapper);
        generator.writeKey("transport_address");
        generator.write(this.transportAddress);
        if (ApiTypeHelper.isDefined(this.attributes)) {
            generator.writeKey("attributes");
            generator.writeStartObject();
            for (Map.Entry entry : this.attributes.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
    }

    protected static void setupStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::adaptiveSelection, JsonpDeserializer.stringMapDeserializer(AdaptiveSelection._DESERIALIZER), "adaptive_selection");
        op.add(Builder::breakers, JsonpDeserializer.stringMapDeserializer(Breaker._DESERIALIZER), "breakers");
        op.add(Builder::fs, FileSystem._DESERIALIZER, "fs");
        op.add(Builder::host, JsonpDeserializer.stringDeserializer(), "host");
        op.add(Builder::http, Http._DESERIALIZER, "http");
        op.add(Builder::indices, IndexStats._DESERIALIZER, "indices");
        op.add(Builder::ingest, Ingest._DESERIALIZER, "ingest");
        op.add(Builder::ip, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ip");
        op.add(Builder::jvm, Jvm._DESERIALIZER, "jvm");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::os, OperatingSystem._DESERIALIZER, "os");
        op.add(Builder::process, Process._DESERIALIZER, "process");
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(NodeRole._DESERIALIZER), "roles");
        op.add(Builder::script, Scripting._DESERIALIZER, "script");
        op.add(Builder::threadPool, JsonpDeserializer.stringMapDeserializer(ThreadCount._DESERIALIZER), "thread_pool");
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp");
        op.add(Builder::transport, Transport._DESERIALIZER, "transport");
        op.add(Builder::transportAddress, JsonpDeserializer.stringDeserializer(), "transport_address");
        op.add(Builder::attributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "attributes");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Stats> {
        private Map<String, AdaptiveSelection> adaptiveSelection;
        private Map<String, Breaker> breakers;
        private FileSystem fs;
        private String host;
        private Http http;
        private IndexStats indices;
        private Ingest ingest;
        private List<String> ip;
        private Jvm jvm;
        private String name;
        private OperatingSystem os;
        private Process process;
        private List<NodeRole> roles;
        private Scripting script;
        private Map<String, ThreadCount> threadPool;
        private Long timestamp;
        private Transport transport;
        private String transportAddress;
        private Map<String, String> attributes;

        public final Builder adaptiveSelection(Map<String, AdaptiveSelection> map) {
            this.adaptiveSelection = Builder._mapPutAll(this.adaptiveSelection, map);
            return this;
        }

        public final Builder adaptiveSelection(String key, AdaptiveSelection value) {
            this.adaptiveSelection = Builder._mapPut(this.adaptiveSelection, key, value);
            return this;
        }

        public final Builder adaptiveSelection(String key, Function<AdaptiveSelection.Builder, ObjectBuilder<AdaptiveSelection>> fn) {
            return this.adaptiveSelection(key, fn.apply(new AdaptiveSelection.Builder()).build());
        }

        public final Builder breakers(Map<String, Breaker> map) {
            this.breakers = Builder._mapPutAll(this.breakers, map);
            return this;
        }

        public final Builder breakers(String key, Breaker value) {
            this.breakers = Builder._mapPut(this.breakers, key, value);
            return this;
        }

        public final Builder breakers(String key, Function<Breaker.Builder, ObjectBuilder<Breaker>> fn) {
            return this.breakers(key, fn.apply(new Breaker.Builder()).build());
        }

        public final Builder fs(FileSystem value) {
            this.fs = value;
            return this;
        }

        public final Builder fs(Function<FileSystem.Builder, ObjectBuilder<FileSystem>> fn) {
            return this.fs(fn.apply(new FileSystem.Builder()).build());
        }

        public final Builder host(String value) {
            this.host = value;
            return this;
        }

        public final Builder http(Http value) {
            this.http = value;
            return this;
        }

        public final Builder http(Function<Http.Builder, ObjectBuilder<Http>> fn) {
            return this.http(fn.apply(new Http.Builder()).build());
        }

        public final Builder indices(IndexStats value) {
            this.indices = value;
            return this;
        }

        public final Builder indices(Function<IndexStats.Builder, ObjectBuilder<IndexStats>> fn) {
            return this.indices(fn.apply(new IndexStats.Builder()).build());
        }

        public final Builder ingest(Ingest value) {
            this.ingest = value;
            return this;
        }

        public final Builder ingest(Function<Ingest.Builder, ObjectBuilder<Ingest>> fn) {
            return this.ingest(fn.apply(new Ingest.Builder()).build());
        }

        public final Builder ip(List<String> list) {
            this.ip = Builder._listAddAll(this.ip, list);
            return this;
        }

        public final Builder ip(String value, String ... values) {
            this.ip = Builder._listAdd(this.ip, value, values);
            return this;
        }

        public final Builder jvm(Jvm value) {
            this.jvm = value;
            return this;
        }

        public final Builder jvm(Function<Jvm.Builder, ObjectBuilder<Jvm>> fn) {
            return this.jvm(fn.apply(new Jvm.Builder()).build());
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder os(OperatingSystem value) {
            this.os = value;
            return this;
        }

        public final Builder os(Function<OperatingSystem.Builder, ObjectBuilder<OperatingSystem>> fn) {
            return this.os(fn.apply(new OperatingSystem.Builder()).build());
        }

        public final Builder process(Process value) {
            this.process = value;
            return this;
        }

        public final Builder process(Function<Process.Builder, ObjectBuilder<Process>> fn) {
            return this.process(fn.apply(new Process.Builder()).build());
        }

        public final Builder roles(List<NodeRole> list) {
            this.roles = Builder._listAddAll(this.roles, list);
            return this;
        }

        public final Builder roles(NodeRole value, NodeRole ... values) {
            this.roles = Builder._listAdd(this.roles, value, values);
            return this;
        }

        public final Builder script(Scripting value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<Scripting.Builder, ObjectBuilder<Scripting>> fn) {
            return this.script(fn.apply(new Scripting.Builder()).build());
        }

        public final Builder threadPool(Map<String, ThreadCount> map) {
            this.threadPool = Builder._mapPutAll(this.threadPool, map);
            return this;
        }

        public final Builder threadPool(String key, ThreadCount value) {
            this.threadPool = Builder._mapPut(this.threadPool, key, value);
            return this;
        }

        public final Builder threadPool(String key, Function<ThreadCount.Builder, ObjectBuilder<ThreadCount>> fn) {
            return this.threadPool(key, fn.apply(new ThreadCount.Builder()).build());
        }

        public final Builder timestamp(long value) {
            this.timestamp = value;
            return this;
        }

        public final Builder transport(Transport value) {
            this.transport = value;
            return this;
        }

        public final Builder transport(Function<Transport.Builder, ObjectBuilder<Transport>> fn) {
            return this.transport(fn.apply(new Transport.Builder()).build());
        }

        public final Builder transportAddress(String value) {
            this.transportAddress = value;
            return this;
        }

        public final Builder attributes(Map<String, String> map) {
            this.attributes = Builder._mapPutAll(this.attributes, map);
            return this;
        }

        public final Builder attributes(String key, String value) {
            this.attributes = Builder._mapPut(this.attributes, key, value);
            return this;
        }

        @Override
        public Stats build() {
            this._checkSingleUse();
            return new Stats(this);
        }
    }
}

