/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.health;

import co.elastic.clients.elasticsearch._types.HealthStatus;
import co.elastic.clients.elasticsearch.cluster.health.ShardHealthStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IndexHealthStats
implements JsonpSerializable {
    private final int activePrimaryShards;
    private final int activeShards;
    private final int initializingShards;
    private final int numberOfReplicas;
    private final int numberOfShards;
    private final int relocatingShards;
    private final Map<String, ShardHealthStats> shards;
    private final HealthStatus status;
    private final int unassignedShards;
    public static final JsonpDeserializer<IndexHealthStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexHealthStats::setupIndexHealthStatsDeserializer);

    private IndexHealthStats(Builder builder) {
        this.activePrimaryShards = ApiTypeHelper.requireNonNull(builder.activePrimaryShards, this, "activePrimaryShards");
        this.activeShards = ApiTypeHelper.requireNonNull(builder.activeShards, this, "activeShards");
        this.initializingShards = ApiTypeHelper.requireNonNull(builder.initializingShards, this, "initializingShards");
        this.numberOfReplicas = ApiTypeHelper.requireNonNull(builder.numberOfReplicas, this, "numberOfReplicas");
        this.numberOfShards = ApiTypeHelper.requireNonNull(builder.numberOfShards, this, "numberOfShards");
        this.relocatingShards = ApiTypeHelper.requireNonNull(builder.relocatingShards, this, "relocatingShards");
        this.shards = ApiTypeHelper.unmodifiable(builder.shards);
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
        this.unassignedShards = ApiTypeHelper.requireNonNull(builder.unassignedShards, this, "unassignedShards");
    }

    public static IndexHealthStats of(Function<Builder, ObjectBuilder<IndexHealthStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int activePrimaryShards() {
        return this.activePrimaryShards;
    }

    public final int activeShards() {
        return this.activeShards;
    }

    public final int initializingShards() {
        return this.initializingShards;
    }

    public final int numberOfReplicas() {
        return this.numberOfReplicas;
    }

    public final int numberOfShards() {
        return this.numberOfShards;
    }

    public final int relocatingShards() {
        return this.relocatingShards;
    }

    public final Map<String, ShardHealthStats> shards() {
        return this.shards;
    }

    public final HealthStatus status() {
        return this.status;
    }

    public final int unassignedShards() {
        return this.unassignedShards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("active_primary_shards");
        generator.write(this.activePrimaryShards);
        generator.writeKey("active_shards");
        generator.write(this.activeShards);
        generator.writeKey("initializing_shards");
        generator.write(this.initializingShards);
        generator.writeKey("number_of_replicas");
        generator.write(this.numberOfReplicas);
        generator.writeKey("number_of_shards");
        generator.write(this.numberOfShards);
        generator.writeKey("relocating_shards");
        generator.write(this.relocatingShards);
        if (ApiTypeHelper.isDefined(this.shards)) {
            generator.writeKey("shards");
            generator.writeStartObject();
            for (Map.Entry<String, ShardHealthStats> item0 : this.shards.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        generator.writeKey("unassigned_shards");
        generator.write(this.unassignedShards);
    }

    protected static void setupIndexHealthStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::activePrimaryShards, JsonpDeserializer.integerDeserializer(), "active_primary_shards");
        op.add(Builder::activeShards, JsonpDeserializer.integerDeserializer(), "active_shards");
        op.add(Builder::initializingShards, JsonpDeserializer.integerDeserializer(), "initializing_shards");
        op.add(Builder::numberOfReplicas, JsonpDeserializer.integerDeserializer(), "number_of_replicas");
        op.add(Builder::numberOfShards, JsonpDeserializer.integerDeserializer(), "number_of_shards");
        op.add(Builder::relocatingShards, JsonpDeserializer.integerDeserializer(), "relocating_shards");
        op.add(Builder::shards, JsonpDeserializer.stringMapDeserializer(ShardHealthStats._DESERIALIZER), "shards");
        op.add(Builder::status, HealthStatus._DESERIALIZER, "status");
        op.add(Builder::unassignedShards, JsonpDeserializer.integerDeserializer(), "unassigned_shards");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<IndexHealthStats> {
        private Integer activePrimaryShards;
        private Integer activeShards;
        private Integer initializingShards;
        private Integer numberOfReplicas;
        private Integer numberOfShards;
        private Integer relocatingShards;
        @Nullable
        private Map<String, ShardHealthStats> shards;
        private HealthStatus status;
        private Integer unassignedShards;

        public final Builder activePrimaryShards(int value) {
            this.activePrimaryShards = value;
            return this;
        }

        public final Builder activeShards(int value) {
            this.activeShards = value;
            return this;
        }

        public final Builder initializingShards(int value) {
            this.initializingShards = value;
            return this;
        }

        public final Builder numberOfReplicas(int value) {
            this.numberOfReplicas = value;
            return this;
        }

        public final Builder numberOfShards(int value) {
            this.numberOfShards = value;
            return this;
        }

        public final Builder relocatingShards(int value) {
            this.relocatingShards = value;
            return this;
        }

        public final Builder shards(Map<String, ShardHealthStats> map) {
            this.shards = Builder._mapPutAll(this.shards, map);
            return this;
        }

        public final Builder shards(String key, ShardHealthStats value) {
            this.shards = Builder._mapPut(this.shards, key, value);
            return this;
        }

        public final Builder shards(String key, Function<ShardHealthStats.Builder, ObjectBuilder<ShardHealthStats>> fn) {
            return this.shards(key, fn.apply(new ShardHealthStats.Builder()).build());
        }

        public final Builder status(HealthStatus value) {
            this.status = value;
            return this;
        }

        public final Builder unassignedShards(int value) {
            this.unassignedShards = value;
            return this;
        }

        @Override
        public IndexHealthStats build() {
            this._checkSingleUse();
            return new IndexHealthStats(this);
        }
    }
}

