/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataframeAnalyticsStatsMemoryUsage
implements JsonpSerializable {
    @Nullable
    private final Long memoryReestimateBytes;
    private final long peakUsageBytes;
    private final String status;
    @Nullable
    private final String timestamp;
    public static final JsonpDeserializer<DataframeAnalyticsStatsMemoryUsage> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeAnalyticsStatsMemoryUsage::setupDataframeAnalyticsStatsMemoryUsageDeserializer);

    private DataframeAnalyticsStatsMemoryUsage(Builder builder) {
        this.memoryReestimateBytes = builder.memoryReestimateBytes;
        this.peakUsageBytes = ApiTypeHelper.requireNonNull(builder.peakUsageBytes, this, "peakUsageBytes");
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
        this.timestamp = builder.timestamp;
    }

    public static DataframeAnalyticsStatsMemoryUsage of(Function<Builder, ObjectBuilder<DataframeAnalyticsStatsMemoryUsage>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long memoryReestimateBytes() {
        return this.memoryReestimateBytes;
    }

    public final long peakUsageBytes() {
        return this.peakUsageBytes;
    }

    public final String status() {
        return this.status;
    }

    @Nullable
    public final String timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.memoryReestimateBytes != null) {
            generator.writeKey("memory_reestimate_bytes");
            generator.write(this.memoryReestimateBytes.longValue());
        }
        generator.writeKey("peak_usage_bytes");
        generator.write(this.peakUsageBytes);
        generator.writeKey("status");
        generator.write(this.status);
        if (this.timestamp != null) {
            generator.writeKey("timestamp");
            generator.write(this.timestamp);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDataframeAnalyticsStatsMemoryUsageDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::memoryReestimateBytes, JsonpDeserializer.longDeserializer(), "memory_reestimate_bytes");
        op.add(Builder::peakUsageBytes, JsonpDeserializer.longDeserializer(), "peak_usage_bytes");
        op.add(Builder::status, JsonpDeserializer.stringDeserializer(), "status");
        op.add(Builder::timestamp, JsonpDeserializer.stringDeserializer(), "timestamp");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataframeAnalyticsStatsMemoryUsage> {
        @Nullable
        private Long memoryReestimateBytes;
        private Long peakUsageBytes;
        private String status;
        @Nullable
        private String timestamp;

        public final Builder memoryReestimateBytes(@Nullable Long value) {
            this.memoryReestimateBytes = value;
            return this;
        }

        public final Builder peakUsageBytes(long value) {
            this.peakUsageBytes = value;
            return this;
        }

        public final Builder status(String value) {
            this.status = value;
            return this;
        }

        public final Builder timestamp(@Nullable String value) {
            this.timestamp = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataframeAnalyticsStatsMemoryUsage build() {
            this._checkSingleUse();
            return new DataframeAnalyticsStatsMemoryUsage(this);
        }
    }
}

