/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.CorePropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NestedProperty
extends CorePropertyBase
implements PropertyVariant {
    @Nullable
    private final Boolean enabled;
    @Nullable
    private final Boolean includeInParent;
    @Nullable
    private final Boolean includeInRoot;
    public static final JsonpDeserializer<NestedProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NestedProperty::setupNestedPropertyDeserializer);

    private NestedProperty(Builder builder) {
        super(builder);
        this.enabled = builder.enabled;
        this.includeInParent = builder.includeInParent;
        this.includeInRoot = builder.includeInRoot;
    }

    public static NestedProperty of(Function<Builder, ObjectBuilder<NestedProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Nested;
    }

    @Nullable
    public final Boolean enabled() {
        return this.enabled;
    }

    @Nullable
    public final Boolean includeInParent() {
        return this.includeInParent;
    }

    @Nullable
    public final Boolean includeInRoot() {
        return this.includeInRoot;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "nested");
        super.serializeInternal(generator, mapper);
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled.booleanValue());
        }
        if (this.includeInParent != null) {
            generator.writeKey("include_in_parent");
            generator.write(this.includeInParent.booleanValue());
        }
        if (this.includeInRoot != null) {
            generator.writeKey("include_in_root");
            generator.write(this.includeInRoot.booleanValue());
        }
    }

    protected static void setupNestedPropertyDeserializer(ObjectDeserializer<Builder> op) {
        CorePropertyBase.setupCorePropertyBaseDeserializer(op);
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.add(Builder::includeInParent, JsonpDeserializer.booleanDeserializer(), "include_in_parent");
        op.add(Builder::includeInRoot, JsonpDeserializer.booleanDeserializer(), "include_in_root");
        op.ignore("type");
    }

    public static class Builder
    extends CorePropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<NestedProperty> {
        @Nullable
        private Boolean enabled;
        @Nullable
        private Boolean includeInParent;
        @Nullable
        private Boolean includeInRoot;

        public final Builder enabled(@Nullable Boolean value) {
            this.enabled = value;
            return this;
        }

        public final Builder includeInParent(@Nullable Boolean value) {
            this.includeInParent = value;
            return this;
        }

        public final Builder includeInRoot(@Nullable Boolean value) {
            this.includeInRoot = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NestedProperty build() {
            this._checkSingleUse();
            return new NestedProperty(this);
        }
    }
}

