/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.async_search;

import co.elastic.clients.elasticsearch.async_search.AsyncSearch;
import co.elastic.clients.elasticsearch.async_search.AsyncSearchResponseBase;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class AsyncSearchDocumentResponseBase<TDocument>
extends AsyncSearchResponseBase {
    private final AsyncSearch<TDocument> response;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;

    protected AsyncSearchDocumentResponseBase(AbstractBuilder<TDocument, ?> builder) {
        super(builder);
        this.response = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).response, this, "response");
        this.tDocumentSerializer = ((AbstractBuilder)builder).tDocumentSerializer;
    }

    public final AsyncSearch<TDocument> response() {
        return this.response;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("response");
        this.response.serialize(generator, mapper);
    }

    protected static <TDocument, BuilderT extends AbstractBuilder<TDocument, BuilderT>> void setupAsyncSearchDocumentResponseBaseDeserializer(ObjectDeserializer<BuilderT> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        AsyncSearchResponseBase.setupAsyncSearchResponseBaseDeserializer(op);
        op.add(AbstractBuilder::response, AsyncSearch.createAsyncSearchDeserializer(tDocumentDeserializer), "response");
    }

    public static abstract class AbstractBuilder<TDocument, BuilderT extends AbstractBuilder<TDocument, BuilderT>>
    extends AsyncSearchResponseBase.AbstractBuilder<BuilderT> {
        private AsyncSearch<TDocument> response;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public final BuilderT response(AsyncSearch<TDocument> value) {
            this.response = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT response(Function<AsyncSearch.Builder<TDocument>, ObjectBuilder<AsyncSearch<TDocument>>> fn) {
            return this.response(fn.apply(new AsyncSearch.Builder()).build());
        }

        public final BuilderT tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

