/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MemoryStats
implements JsonpSerializable {
    @Nullable
    private final Long adjustedTotalInBytes;
    @Nullable
    private final String resident;
    @Nullable
    private final Long residentInBytes;
    @Nullable
    private final String share;
    @Nullable
    private final Long shareInBytes;
    @Nullable
    private final String totalVirtual;
    @Nullable
    private final Long totalVirtualInBytes;
    @Nullable
    private final Long totalInBytes;
    @Nullable
    private final Long freeInBytes;
    @Nullable
    private final Long usedInBytes;
    public static final JsonpDeserializer<MemoryStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MemoryStats::setupMemoryStatsDeserializer);

    protected MemoryStats(AbstractBuilder<?> builder) {
        this.adjustedTotalInBytes = ((AbstractBuilder)builder).adjustedTotalInBytes;
        this.resident = ((AbstractBuilder)builder).resident;
        this.residentInBytes = ((AbstractBuilder)builder).residentInBytes;
        this.share = ((AbstractBuilder)builder).share;
        this.shareInBytes = ((AbstractBuilder)builder).shareInBytes;
        this.totalVirtual = ((AbstractBuilder)builder).totalVirtual;
        this.totalVirtualInBytes = ((AbstractBuilder)builder).totalVirtualInBytes;
        this.totalInBytes = ((AbstractBuilder)builder).totalInBytes;
        this.freeInBytes = ((AbstractBuilder)builder).freeInBytes;
        this.usedInBytes = ((AbstractBuilder)builder).usedInBytes;
    }

    public static MemoryStats memoryStatsOf(Function<Builder, ObjectBuilder<MemoryStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long adjustedTotalInBytes() {
        return this.adjustedTotalInBytes;
    }

    @Nullable
    public final String resident() {
        return this.resident;
    }

    @Nullable
    public final Long residentInBytes() {
        return this.residentInBytes;
    }

    @Nullable
    public final String share() {
        return this.share;
    }

    @Nullable
    public final Long shareInBytes() {
        return this.shareInBytes;
    }

    @Nullable
    public final String totalVirtual() {
        return this.totalVirtual;
    }

    @Nullable
    public final Long totalVirtualInBytes() {
        return this.totalVirtualInBytes;
    }

    @Nullable
    public final Long totalInBytes() {
        return this.totalInBytes;
    }

    @Nullable
    public final Long freeInBytes() {
        return this.freeInBytes;
    }

    @Nullable
    public final Long usedInBytes() {
        return this.usedInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.adjustedTotalInBytes != null) {
            generator.writeKey("adjusted_total_in_bytes");
            generator.write(this.adjustedTotalInBytes.longValue());
        }
        if (this.resident != null) {
            generator.writeKey("resident");
            generator.write(this.resident);
        }
        if (this.residentInBytes != null) {
            generator.writeKey("resident_in_bytes");
            generator.write(this.residentInBytes.longValue());
        }
        if (this.share != null) {
            generator.writeKey("share");
            generator.write(this.share);
        }
        if (this.shareInBytes != null) {
            generator.writeKey("share_in_bytes");
            generator.write(this.shareInBytes.longValue());
        }
        if (this.totalVirtual != null) {
            generator.writeKey("total_virtual");
            generator.write(this.totalVirtual);
        }
        if (this.totalVirtualInBytes != null) {
            generator.writeKey("total_virtual_in_bytes");
            generator.write(this.totalVirtualInBytes.longValue());
        }
        if (this.totalInBytes != null) {
            generator.writeKey("total_in_bytes");
            generator.write(this.totalInBytes.longValue());
        }
        if (this.freeInBytes != null) {
            generator.writeKey("free_in_bytes");
            generator.write(this.freeInBytes.longValue());
        }
        if (this.usedInBytes != null) {
            generator.writeKey("used_in_bytes");
            generator.write(this.usedInBytes.longValue());
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupMemoryStatsDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::adjustedTotalInBytes, JsonpDeserializer.longDeserializer(), "adjusted_total_in_bytes");
        op.add(AbstractBuilder::resident, JsonpDeserializer.stringDeserializer(), "resident");
        op.add(AbstractBuilder::residentInBytes, JsonpDeserializer.longDeserializer(), "resident_in_bytes");
        op.add(AbstractBuilder::share, JsonpDeserializer.stringDeserializer(), "share");
        op.add(AbstractBuilder::shareInBytes, JsonpDeserializer.longDeserializer(), "share_in_bytes");
        op.add(AbstractBuilder::totalVirtual, JsonpDeserializer.stringDeserializer(), "total_virtual");
        op.add(AbstractBuilder::totalVirtualInBytes, JsonpDeserializer.longDeserializer(), "total_virtual_in_bytes");
        op.add(AbstractBuilder::totalInBytes, JsonpDeserializer.longDeserializer(), "total_in_bytes");
        op.add(AbstractBuilder::freeInBytes, JsonpDeserializer.longDeserializer(), "free_in_bytes");
        op.add(AbstractBuilder::usedInBytes, JsonpDeserializer.longDeserializer(), "used_in_bytes");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private Long adjustedTotalInBytes;
        @Nullable
        private String resident;
        @Nullable
        private Long residentInBytes;
        @Nullable
        private String share;
        @Nullable
        private Long shareInBytes;
        @Nullable
        private String totalVirtual;
        @Nullable
        private Long totalVirtualInBytes;
        @Nullable
        private Long totalInBytes;
        @Nullable
        private Long freeInBytes;
        @Nullable
        private Long usedInBytes;

        protected AbstractBuilder() {
        }

        public final BuilderT adjustedTotalInBytes(@Nullable Long value) {
            this.adjustedTotalInBytes = value;
            return (BuilderT)this.self();
        }

        public final BuilderT resident(@Nullable String value) {
            this.resident = value;
            return (BuilderT)this.self();
        }

        public final BuilderT residentInBytes(@Nullable Long value) {
            this.residentInBytes = value;
            return (BuilderT)this.self();
        }

        public final BuilderT share(@Nullable String value) {
            this.share = value;
            return (BuilderT)this.self();
        }

        public final BuilderT shareInBytes(@Nullable Long value) {
            this.shareInBytes = value;
            return (BuilderT)this.self();
        }

        public final BuilderT totalVirtual(@Nullable String value) {
            this.totalVirtual = value;
            return (BuilderT)this.self();
        }

        public final BuilderT totalVirtualInBytes(@Nullable Long value) {
            this.totalVirtualInBytes = value;
            return (BuilderT)this.self();
        }

        public final BuilderT totalInBytes(@Nullable Long value) {
            this.totalInBytes = value;
            return (BuilderT)this.self();
        }

        public final BuilderT freeInBytes(@Nullable Long value) {
            this.freeInBytes = value;
            return (BuilderT)this.self();
        }

        public final BuilderT usedInBytes(@Nullable Long value) {
            this.usedInBytes = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<MemoryStats> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MemoryStats build() {
            this._checkSingleUse();
            return new MemoryStats(this);
        }
    }
}

