/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsFieldSelection;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsMemoryEstimation;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class ExplainDataFrameAnalyticsResponse
implements JsonpSerializable {
    private final List<DataframeAnalyticsFieldSelection> fieldSelection;
    private final DataframeAnalyticsMemoryEstimation memoryEstimation;
    public static final JsonpDeserializer<ExplainDataFrameAnalyticsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExplainDataFrameAnalyticsResponse::setupExplainDataFrameAnalyticsResponseDeserializer);

    private ExplainDataFrameAnalyticsResponse(Builder builder) {
        this.fieldSelection = ApiTypeHelper.unmodifiableRequired(builder.fieldSelection, (Object)this, "fieldSelection");
        this.memoryEstimation = ApiTypeHelper.requireNonNull(builder.memoryEstimation, this, "memoryEstimation");
    }

    public static ExplainDataFrameAnalyticsResponse of(Function<Builder, ObjectBuilder<ExplainDataFrameAnalyticsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<DataframeAnalyticsFieldSelection> fieldSelection() {
        return this.fieldSelection;
    }

    public final DataframeAnalyticsMemoryEstimation memoryEstimation() {
        return this.memoryEstimation;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.fieldSelection)) {
            generator.writeKey("field_selection");
            generator.writeStartArray();
            for (DataframeAnalyticsFieldSelection item0 : this.fieldSelection) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("memory_estimation");
        this.memoryEstimation.serialize(generator, mapper);
    }

    protected static void setupExplainDataFrameAnalyticsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fieldSelection, JsonpDeserializer.arrayDeserializer(DataframeAnalyticsFieldSelection._DESERIALIZER), "field_selection");
        op.add(Builder::memoryEstimation, DataframeAnalyticsMemoryEstimation._DESERIALIZER, "memory_estimation");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ExplainDataFrameAnalyticsResponse> {
        private List<DataframeAnalyticsFieldSelection> fieldSelection;
        private DataframeAnalyticsMemoryEstimation memoryEstimation;

        public final Builder fieldSelection(List<DataframeAnalyticsFieldSelection> list) {
            this.fieldSelection = Builder._listAddAll(this.fieldSelection, list);
            return this;
        }

        public final Builder fieldSelection(DataframeAnalyticsFieldSelection value, DataframeAnalyticsFieldSelection ... values) {
            this.fieldSelection = Builder._listAdd(this.fieldSelection, value, values);
            return this;
        }

        public final Builder fieldSelection(Function<DataframeAnalyticsFieldSelection.Builder, ObjectBuilder<DataframeAnalyticsFieldSelection>> fn) {
            return this.fieldSelection(fn.apply(new DataframeAnalyticsFieldSelection.Builder()).build(), new DataframeAnalyticsFieldSelection[0]);
        }

        public final Builder memoryEstimation(DataframeAnalyticsMemoryEstimation value) {
            this.memoryEstimation = value;
            return this;
        }

        public final Builder memoryEstimation(Function<DataframeAnalyticsMemoryEstimation.Builder, ObjectBuilder<DataframeAnalyticsMemoryEstimation>> fn) {
            return this.memoryEstimation(fn.apply(new DataframeAnalyticsMemoryEstimation.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ExplainDataFrameAnalyticsResponse build() {
            this._checkSingleUse();
            return new ExplainDataFrameAnalyticsResponse(this);
        }
    }
}

