/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.logstash;

import co.elastic.clients.elasticsearch.logstash.PipelineMetadata;
import co.elastic.clients.elasticsearch.logstash.PipelineSettings;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Pipeline
implements JsonpSerializable {
    private final String description;
    private final String lastModified;
    private final PipelineMetadata pipelineMetadata;
    private final String username;
    private final String pipeline;
    private final PipelineSettings pipelineSettings;
    public static final JsonpDeserializer<Pipeline> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Pipeline::setupPipelineDeserializer);

    private Pipeline(Builder builder) {
        this.description = ApiTypeHelper.requireNonNull(builder.description, this, "description");
        this.lastModified = ApiTypeHelper.requireNonNull(builder.lastModified, this, "lastModified");
        this.pipelineMetadata = ApiTypeHelper.requireNonNull(builder.pipelineMetadata, this, "pipelineMetadata");
        this.username = ApiTypeHelper.requireNonNull(builder.username, this, "username");
        this.pipeline = ApiTypeHelper.requireNonNull(builder.pipeline, this, "pipeline");
        this.pipelineSettings = ApiTypeHelper.requireNonNull(builder.pipelineSettings, this, "pipelineSettings");
    }

    public static Pipeline of(Function<Builder, ObjectBuilder<Pipeline>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String description() {
        return this.description;
    }

    public final String lastModified() {
        return this.lastModified;
    }

    public final PipelineMetadata pipelineMetadata() {
        return this.pipelineMetadata;
    }

    public final String username() {
        return this.username;
    }

    public final String pipeline() {
        return this.pipeline;
    }

    public final PipelineSettings pipelineSettings() {
        return this.pipelineSettings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("description");
        generator.write(this.description);
        generator.writeKey("last_modified");
        generator.write(this.lastModified);
        generator.writeKey("pipeline_metadata");
        this.pipelineMetadata.serialize(generator, mapper);
        generator.writeKey("username");
        generator.write(this.username);
        generator.writeKey("pipeline");
        generator.write(this.pipeline);
        generator.writeKey("pipeline_settings");
        this.pipelineSettings.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupPipelineDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::lastModified, JsonpDeserializer.stringDeserializer(), "last_modified");
        op.add(Builder::pipelineMetadata, PipelineMetadata._DESERIALIZER, "pipeline_metadata");
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username");
        op.add(Builder::pipeline, JsonpDeserializer.stringDeserializer(), "pipeline");
        op.add(Builder::pipelineSettings, PipelineSettings._DESERIALIZER, "pipeline_settings");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Pipeline> {
        private String description;
        private String lastModified;
        private PipelineMetadata pipelineMetadata;
        private String username;
        private String pipeline;
        private PipelineSettings pipelineSettings;

        public final Builder description(String value) {
            this.description = value;
            return this;
        }

        public final Builder lastModified(String value) {
            this.lastModified = value;
            return this;
        }

        public final Builder pipelineMetadata(PipelineMetadata value) {
            this.pipelineMetadata = value;
            return this;
        }

        public final Builder pipelineMetadata(Function<PipelineMetadata.Builder, ObjectBuilder<PipelineMetadata>> fn) {
            return this.pipelineMetadata(fn.apply(new PipelineMetadata.Builder()).build());
        }

        public final Builder username(String value) {
            this.username = value;
            return this;
        }

        public final Builder pipeline(String value) {
            this.pipeline = value;
            return this;
        }

        public final Builder pipelineSettings(PipelineSettings value) {
            this.pipelineSettings = value;
            return this;
        }

        public final Builder pipelineSettings(Function<PipelineSettings.Builder, ObjectBuilder<PipelineSettings>> fn) {
            return this.pipelineSettings(fn.apply(new PipelineSettings.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Pipeline build() {
            this._checkSingleUse();
            return new Pipeline(this);
        }
    }
}

