/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class JoinProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    private final String separator;
    @Nullable
    private final String targetField;
    public static final JsonpDeserializer<JoinProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JoinProcessor::setupJoinProcessorDeserializer);

    private JoinProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.separator = ApiTypeHelper.requireNonNull(builder.separator, this, "separator");
        this.targetField = builder.targetField;
    }

    public static JoinProcessor of(Function<Builder, ObjectBuilder<JoinProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Join;
    }

    public final String field() {
        return this.field;
    }

    public final String separator() {
        return this.separator;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("separator");
        generator.write(this.separator);
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
    }

    protected static void setupJoinProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::separator, JsonpDeserializer.stringDeserializer(), "separator");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<JoinProcessor> {
        private String field;
        private String separator;
        @Nullable
        private String targetField;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder separator(String value) {
            this.separator = value;
            return this;
        }

        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public JoinProcessor build() {
            this._checkSingleUse();
            return new JoinProcessor(this);
        }
    }
}

