/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.sql;

import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch.core.search.SourceConfig;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class TranslateResponse
implements JsonpSerializable {
    private final long size;
    private final SourceConfig source;
    private final List<Map<String, String>> fields;
    private final List<SortOptions> sort;
    public static final JsonpDeserializer<TranslateResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TranslateResponse::setupTranslateResponseDeserializer);

    private TranslateResponse(Builder builder) {
        this.size = ApiTypeHelper.requireNonNull(builder.size, this, "size");
        this.source = ApiTypeHelper.requireNonNull(builder.source, this, "source");
        this.fields = ApiTypeHelper.unmodifiableRequired(builder.fields, (Object)this, "fields");
        this.sort = ApiTypeHelper.unmodifiableRequired(builder.sort, (Object)this, "sort");
    }

    public static TranslateResponse of(Function<Builder, ObjectBuilder<TranslateResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long size() {
        return this.size;
    }

    public final SourceConfig source() {
        return this.source;
    }

    public final List<Map<String, String>> fields() {
        return this.fields;
    }

    public final List<SortOptions> sort() {
        return this.sort;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("size");
        generator.write(this.size);
        generator.writeKey("_source");
        this.source.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (Map<String, String> map : this.fields) {
                generator.writeStartObject();
                if (map != null) {
                    for (Map.Entry<String, String> item1 : map.entrySet()) {
                        generator.writeKey(item1.getKey());
                        generator.write(item1.getValue());
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.sort)) {
            generator.writeKey("sort");
            generator.writeStartArray();
            for (SortOptions sortOptions : this.sort) {
                sortOptions.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupTranslateResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::size, JsonpDeserializer.longDeserializer(), "size");
        op.add(Builder::source, SourceConfig._DESERIALIZER, "_source");
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer())), "fields");
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(SortOptions._DESERIALIZER), "sort");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<TranslateResponse> {
        private Long size;
        private SourceConfig source;
        private List<Map<String, String>> fields;
        private List<SortOptions> sort;

        public final Builder size(long value) {
            this.size = value;
            return this;
        }

        public final Builder source(SourceConfig value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<SourceConfig.Builder, ObjectBuilder<SourceConfig>> fn) {
            return this.source(fn.apply(new SourceConfig.Builder()).build());
        }

        public final Builder fields(List<Map<String, String>> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(Map<String, String> value, Map<String, String> ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder sort(List<SortOptions> list) {
            this.sort = Builder._listAddAll(this.sort, list);
            return this;
        }

        public final Builder sort(SortOptions value, SortOptions ... values) {
            this.sort = Builder._listAdd(this.sort, value, values);
            return this;
        }

        public final Builder sort(Function<SortOptions.Builder, ObjectBuilder<SortOptions>> fn) {
            return this.sort(fn.apply(new SortOptions.Builder()).build(), new SortOptions[0]);
        }

        @Override
        public TranslateResponse build() {
            this._checkSingleUse();
            return new TranslateResponse(this);
        }
    }
}

