/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup.get_rollup_index_caps;

import co.elastic.clients.elasticsearch.rollup.get_rollup_index_caps.RollupJobSummaryField;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class RollupJobSummary
implements JsonpSerializable {
    private final Map<String, List<RollupJobSummaryField>> fields;
    private final String indexPattern;
    private final String jobId;
    private final String rollupIndex;
    public static final JsonpDeserializer<RollupJobSummary> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RollupJobSummary::setupRollupJobSummaryDeserializer);

    private RollupJobSummary(Builder builder) {
        this.fields = ApiTypeHelper.unmodifiableRequired(builder.fields, (Object)this, "fields");
        this.indexPattern = ApiTypeHelper.requireNonNull(builder.indexPattern, this, "indexPattern");
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.rollupIndex = ApiTypeHelper.requireNonNull(builder.rollupIndex, this, "rollupIndex");
    }

    public static RollupJobSummary of(Function<Builder, ObjectBuilder<RollupJobSummary>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, List<RollupJobSummaryField>> fields() {
        return this.fields;
    }

    public final String indexPattern() {
        return this.indexPattern;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String rollupIndex() {
        return this.rollupIndex;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, List<RollupJobSummaryField>> item0 : this.fields.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.writeStartArray();
                if (item0.getValue() != null) {
                    for (RollupJobSummaryField item1 : item0.getValue()) {
                        item1.serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        generator.writeKey("index_pattern");
        generator.write(this.indexPattern);
        generator.writeKey("job_id");
        generator.write(this.jobId);
        generator.writeKey("rollup_index");
        generator.write(this.rollupIndex);
    }

    protected static void setupRollupJobSummaryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(RollupJobSummaryField._DESERIALIZER)), "fields");
        op.add(Builder::indexPattern, JsonpDeserializer.stringDeserializer(), "index_pattern");
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id");
        op.add(Builder::rollupIndex, JsonpDeserializer.stringDeserializer(), "rollup_index");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RollupJobSummary> {
        private Map<String, List<RollupJobSummaryField>> fields;
        private String indexPattern;
        private String jobId;
        private String rollupIndex;

        public final Builder fields(Map<String, List<RollupJobSummaryField>> map) {
            this.fields = Builder._mapPutAll(this.fields, map);
            return this;
        }

        public final Builder fields(String key, List<RollupJobSummaryField> value) {
            this.fields = Builder._mapPut(this.fields, key, value);
            return this;
        }

        public final Builder indexPattern(String value) {
            this.indexPattern = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder rollupIndex(String value) {
            this.rollupIndex = value;
            return this;
        }

        @Override
        public RollupJobSummary build() {
            this._checkSingleUse();
            return new RollupJobSummary(this);
        }
    }
}

