/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.CatTransformColumn;
import co.elastic.clients.elasticsearch.cat.TransformsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class TransformsRequest
extends CatRequestBase {
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Integer from;
    private final List<CatTransformColumn> h;
    private final List<CatTransformColumn> s;
    @Nullable
    private final Integer size;
    @Nullable
    private final Time time;
    @Nullable
    private final String transformId;
    public static final Endpoint<TransformsRequest, TransformsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<TransformsRequest, TransformsResponse>("es/cat.transforms", request -> "GET", request -> {
        boolean _transformId = true;
        boolean propsSet = false;
        if (request.transformId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/transforms");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/transforms");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.transformId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (ApiTypeHelper.isDefined(request.s)) {
            params.put("s", request.s.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (ApiTypeHelper.isDefined(request.h)) {
            params.put("h", request.h.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.time != null) {
            params.put("time", request.time._toJsonString());
        }
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, TransformsResponse._DESERIALIZER);

    private TransformsRequest(Builder builder) {
        this.allowNoMatch = builder.allowNoMatch;
        this.from = builder.from;
        this.h = ApiTypeHelper.unmodifiable(builder.h);
        this.s = ApiTypeHelper.unmodifiable(builder.s);
        this.size = builder.size;
        this.time = builder.time;
        this.transformId = builder.transformId;
    }

    public static TransformsRequest of(Function<Builder, ObjectBuilder<TransformsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    public final List<CatTransformColumn> h() {
        return this.h;
    }

    public final List<CatTransformColumn> s() {
        return this.s;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final Time time() {
        return this.time;
    }

    @Nullable
    public final String transformId() {
        return this.transformId;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<TransformsRequest> {
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Integer from;
        @Nullable
        private List<CatTransformColumn> h;
        @Nullable
        private List<CatTransformColumn> s;
        @Nullable
        private Integer size;
        @Nullable
        private Time time;
        @Nullable
        private String transformId;

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder h(List<CatTransformColumn> list) {
            this.h = Builder._listAddAll(this.h, list);
            return this;
        }

        public final Builder h(CatTransformColumn value, CatTransformColumn ... values) {
            this.h = Builder._listAdd(this.h, value, values);
            return this;
        }

        public final Builder s(List<CatTransformColumn> list) {
            this.s = Builder._listAddAll(this.s, list);
            return this;
        }

        public final Builder s(CatTransformColumn value, CatTransformColumn ... values) {
            this.s = Builder._listAdd(this.s, value, values);
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder time(@Nullable Time value) {
            this.time = value;
            return this;
        }

        public final Builder time(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.time(fn.apply(new Time.Builder()).build());
        }

        public final Builder transformId(@Nullable String value) {
            this.transformId = value;
            return this;
        }

        @Override
        public TransformsRequest build() {
            this._checkSingleUse();
            return new TransformsRequest(this);
        }
    }
}

