/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class DistanceFeatureQuery
extends QueryBase
implements QueryVariant {
    private final JsonData origin;
    private final JsonData pivot;
    private final String field;
    public static final JsonpDeserializer<DistanceFeatureQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DistanceFeatureQuery::setupDistanceFeatureQueryDeserializer);

    private DistanceFeatureQuery(Builder builder) {
        super(builder);
        this.origin = ApiTypeHelper.requireNonNull(builder.origin, this, "origin");
        this.pivot = ApiTypeHelper.requireNonNull(builder.pivot, this, "pivot");
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
    }

    public static DistanceFeatureQuery of(Function<Builder, ObjectBuilder<DistanceFeatureQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.DistanceFeature;
    }

    public final JsonData origin() {
        return this.origin;
    }

    public final JsonData pivot() {
        return this.pivot;
    }

    public final String field() {
        return this.field;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("origin");
        this.origin.serialize(generator, mapper);
        generator.writeKey("pivot");
        this.pivot.serialize(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
    }

    protected static void setupDistanceFeatureQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::origin, JsonData._DESERIALIZER, "origin");
        op.add(Builder::pivot, JsonData._DESERIALIZER, "pivot");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DistanceFeatureQuery> {
        private JsonData origin;
        private JsonData pivot;
        private String field;

        public final Builder origin(JsonData value) {
            this.origin = value;
            return this;
        }

        public final Builder pivot(JsonData value) {
            this.pivot = value;
            return this;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DistanceFeatureQuery build() {
            this._checkSingleUse();
            return new DistanceFeatureQuery(this);
        }
    }
}

