/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.tasks;

import co.elastic.clients.ApiClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch.tasks.CancelRequest;
import co.elastic.clients.elasticsearch.tasks.CancelResponse;
import co.elastic.clients.elasticsearch.tasks.GetTasksRequest;
import co.elastic.clients.elasticsearch.tasks.GetTasksResponse;
import co.elastic.clients.elasticsearch.tasks.ListRequest;
import co.elastic.clients.elasticsearch.tasks.ListResponse;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.JsonEndpoint;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.util.ObjectBuilder;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ElasticsearchTasksAsyncClient
extends ApiClient<ElasticsearchTransport, ElasticsearchTasksAsyncClient> {
    public ElasticsearchTasksAsyncClient(ElasticsearchTransport transport) {
        super(transport, null);
    }

    public ElasticsearchTasksAsyncClient(ElasticsearchTransport transport, @Nullable TransportOptions transportOptions) {
        super(transport, transportOptions);
    }

    @Override
    public ElasticsearchTasksAsyncClient withTransportOptions(@Nullable TransportOptions transportOptions) {
        return new ElasticsearchTasksAsyncClient((ElasticsearchTransport)this.transport, transportOptions);
    }

    public CompletableFuture<CancelResponse> cancel(CancelRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)CancelRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<CancelResponse> cancel(Function<CancelRequest.Builder, ObjectBuilder<CancelRequest>> fn) throws IOException, ElasticsearchException {
        return this.cancel(fn.apply(new CancelRequest.Builder()).build());
    }

    public CompletableFuture<CancelResponse> cancel() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(new CancelRequest.Builder().build(), CancelRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<GetTasksResponse> get(GetTasksRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)GetTasksRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<GetTasksResponse> get(Function<GetTasksRequest.Builder, ObjectBuilder<GetTasksRequest>> fn) throws IOException, ElasticsearchException {
        return this.get(fn.apply(new GetTasksRequest.Builder()).build());
    }

    public CompletableFuture<ListResponse> list(ListRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)ListRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<ListResponse> list(Function<ListRequest.Builder, ObjectBuilder<ListRequest>> fn) throws IOException, ElasticsearchException {
        return this.list(fn.apply(new ListRequest.Builder()).build());
    }

    public CompletableFuture<ListResponse> list() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(new ListRequest.Builder().build(), ListRequest._ENDPOINT, this.transportOptions);
    }
}

