/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ml.CategorizationAnalyzer;
import co.elastic.clients.elasticsearch.ml.Detector;
import co.elastic.clients.elasticsearch.ml.PerPartitionCategorization;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AnalysisConfig
implements JsonpSerializable {
    private final String bucketSpan;
    @Nullable
    private final CategorizationAnalyzer categorizationAnalyzer;
    @Nullable
    private final String categorizationFieldName;
    private final List<String> categorizationFilters;
    private final List<Detector> detectors;
    private final List<String> influencers;
    @Nullable
    private final Time modelPruneWindow;
    @Nullable
    private final Time latency;
    @Nullable
    private final Boolean multivariateByFields;
    @Nullable
    private final PerPartitionCategorization perPartitionCategorization;
    @Nullable
    private final String summaryCountFieldName;
    public static final JsonpDeserializer<AnalysisConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AnalysisConfig::setupAnalysisConfigDeserializer);

    private AnalysisConfig(Builder builder) {
        this.bucketSpan = ApiTypeHelper.requireNonNull(builder.bucketSpan, this, "bucketSpan");
        this.categorizationAnalyzer = builder.categorizationAnalyzer;
        this.categorizationFieldName = builder.categorizationFieldName;
        this.categorizationFilters = ApiTypeHelper.unmodifiable(builder.categorizationFilters);
        this.detectors = ApiTypeHelper.unmodifiableRequired(builder.detectors, (Object)this, "detectors");
        this.influencers = ApiTypeHelper.unmodifiable(builder.influencers);
        this.modelPruneWindow = builder.modelPruneWindow;
        this.latency = builder.latency;
        this.multivariateByFields = builder.multivariateByFields;
        this.perPartitionCategorization = builder.perPartitionCategorization;
        this.summaryCountFieldName = builder.summaryCountFieldName;
    }

    public static AnalysisConfig of(Function<Builder, ObjectBuilder<AnalysisConfig>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String bucketSpan() {
        return this.bucketSpan;
    }

    @Nullable
    public final CategorizationAnalyzer categorizationAnalyzer() {
        return this.categorizationAnalyzer;
    }

    @Nullable
    public final String categorizationFieldName() {
        return this.categorizationFieldName;
    }

    public final List<String> categorizationFilters() {
        return this.categorizationFilters;
    }

    public final List<Detector> detectors() {
        return this.detectors;
    }

    public final List<String> influencers() {
        return this.influencers;
    }

    @Nullable
    public final Time modelPruneWindow() {
        return this.modelPruneWindow;
    }

    @Nullable
    public final Time latency() {
        return this.latency;
    }

    @Nullable
    public final Boolean multivariateByFields() {
        return this.multivariateByFields;
    }

    @Nullable
    public final PerPartitionCategorization perPartitionCategorization() {
        return this.perPartitionCategorization;
    }

    @Nullable
    public final String summaryCountFieldName() {
        return this.summaryCountFieldName;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bucket_span");
        generator.write(this.bucketSpan);
        if (this.categorizationAnalyzer != null) {
            generator.writeKey("categorization_analyzer");
            this.categorizationAnalyzer.serialize(generator, mapper);
        }
        if (this.categorizationFieldName != null) {
            generator.writeKey("categorization_field_name");
            generator.write(this.categorizationFieldName);
        }
        if (ApiTypeHelper.isDefined(this.categorizationFilters)) {
            generator.writeKey("categorization_filters");
            generator.writeStartArray();
            for (String string : this.categorizationFilters) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.detectors)) {
            generator.writeKey("detectors");
            generator.writeStartArray();
            for (Detector detector : this.detectors) {
                detector.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.influencers)) {
            generator.writeKey("influencers");
            generator.writeStartArray();
            for (String string : this.influencers) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.modelPruneWindow != null) {
            generator.writeKey("model_prune_window");
            this.modelPruneWindow.serialize(generator, mapper);
        }
        if (this.latency != null) {
            generator.writeKey("latency");
            this.latency.serialize(generator, mapper);
        }
        if (this.multivariateByFields != null) {
            generator.writeKey("multivariate_by_fields");
            generator.write(this.multivariateByFields.booleanValue());
        }
        if (this.perPartitionCategorization != null) {
            generator.writeKey("per_partition_categorization");
            this.perPartitionCategorization.serialize(generator, mapper);
        }
        if (this.summaryCountFieldName != null) {
            generator.writeKey("summary_count_field_name");
            generator.write(this.summaryCountFieldName);
        }
    }

    protected static void setupAnalysisConfigDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::bucketSpan, JsonpDeserializer.stringDeserializer(), "bucket_span");
        op.add(Builder::categorizationAnalyzer, CategorizationAnalyzer._DESERIALIZER, "categorization_analyzer");
        op.add(Builder::categorizationFieldName, JsonpDeserializer.stringDeserializer(), "categorization_field_name");
        op.add(Builder::categorizationFilters, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "categorization_filters");
        op.add(Builder::detectors, JsonpDeserializer.arrayDeserializer(Detector._DESERIALIZER), "detectors");
        op.add(Builder::influencers, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "influencers");
        op.add(Builder::modelPruneWindow, Time._DESERIALIZER, "model_prune_window");
        op.add(Builder::latency, Time._DESERIALIZER, "latency");
        op.add(Builder::multivariateByFields, JsonpDeserializer.booleanDeserializer(), "multivariate_by_fields");
        op.add(Builder::perPartitionCategorization, PerPartitionCategorization._DESERIALIZER, "per_partition_categorization");
        op.add(Builder::summaryCountFieldName, JsonpDeserializer.stringDeserializer(), "summary_count_field_name");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<AnalysisConfig> {
        private String bucketSpan;
        @Nullable
        private CategorizationAnalyzer categorizationAnalyzer;
        @Nullable
        private String categorizationFieldName;
        @Nullable
        private List<String> categorizationFilters;
        private List<Detector> detectors;
        @Nullable
        private List<String> influencers;
        @Nullable
        private Time modelPruneWindow;
        @Nullable
        private Time latency;
        @Nullable
        private Boolean multivariateByFields;
        @Nullable
        private PerPartitionCategorization perPartitionCategorization;
        @Nullable
        private String summaryCountFieldName;

        public final Builder bucketSpan(String value) {
            this.bucketSpan = value;
            return this;
        }

        public final Builder categorizationAnalyzer(@Nullable CategorizationAnalyzer value) {
            this.categorizationAnalyzer = value;
            return this;
        }

        public final Builder categorizationAnalyzer(Function<CategorizationAnalyzer.Builder, ObjectBuilder<CategorizationAnalyzer>> fn) {
            return this.categorizationAnalyzer(fn.apply(new CategorizationAnalyzer.Builder()).build());
        }

        public final Builder categorizationFieldName(@Nullable String value) {
            this.categorizationFieldName = value;
            return this;
        }

        public final Builder categorizationFilters(List<String> list) {
            this.categorizationFilters = Builder._listAddAll(this.categorizationFilters, list);
            return this;
        }

        public final Builder categorizationFilters(String value, String ... values) {
            this.categorizationFilters = Builder._listAdd(this.categorizationFilters, value, values);
            return this;
        }

        public final Builder detectors(List<Detector> list) {
            this.detectors = Builder._listAddAll(this.detectors, list);
            return this;
        }

        public final Builder detectors(Detector value, Detector ... values) {
            this.detectors = Builder._listAdd(this.detectors, value, values);
            return this;
        }

        public final Builder detectors(Function<Detector.Builder, ObjectBuilder<Detector>> fn) {
            return this.detectors(fn.apply(new Detector.Builder()).build(), new Detector[0]);
        }

        public final Builder influencers(List<String> list) {
            this.influencers = Builder._listAddAll(this.influencers, list);
            return this;
        }

        public final Builder influencers(String value, String ... values) {
            this.influencers = Builder._listAdd(this.influencers, value, values);
            return this;
        }

        public final Builder modelPruneWindow(@Nullable Time value) {
            this.modelPruneWindow = value;
            return this;
        }

        public final Builder modelPruneWindow(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.modelPruneWindow(fn.apply(new Time.Builder()).build());
        }

        public final Builder latency(@Nullable Time value) {
            this.latency = value;
            return this;
        }

        public final Builder latency(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.latency(fn.apply(new Time.Builder()).build());
        }

        public final Builder multivariateByFields(@Nullable Boolean value) {
            this.multivariateByFields = value;
            return this;
        }

        public final Builder perPartitionCategorization(@Nullable PerPartitionCategorization value) {
            this.perPartitionCategorization = value;
            return this;
        }

        public final Builder perPartitionCategorization(Function<PerPartitionCategorization.Builder, ObjectBuilder<PerPartitionCategorization>> fn) {
            return this.perPartitionCategorization(fn.apply(new PerPartitionCategorization.Builder()).build());
        }

        public final Builder summaryCountFieldName(@Nullable String value) {
            this.summaryCountFieldName = value;
            return this;
        }

        @Override
        public AnalysisConfig build() {
            this._checkSingleUse();
            return new AnalysisConfig(this);
        }
    }
}

