/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.elasticsearch._types.HealthStatus;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterIndices;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterNodes;
import co.elastic.clients.elasticsearch.nodes.NodesResponseBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ClusterStatsResponse
extends NodesResponseBase {
    private final String clusterName;
    private final String clusterUuid;
    private final ClusterIndices indices;
    private final ClusterNodes nodes;
    private final HealthStatus status;
    private final long timestamp;
    public static final JsonpDeserializer<ClusterStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterStatsResponse::setupClusterStatsResponseDeserializer);

    private ClusterStatsResponse(Builder builder) {
        super(builder);
        this.clusterName = ApiTypeHelper.requireNonNull(builder.clusterName, this, "clusterName");
        this.clusterUuid = ApiTypeHelper.requireNonNull(builder.clusterUuid, this, "clusterUuid");
        this.indices = ApiTypeHelper.requireNonNull(builder.indices, this, "indices");
        this.nodes = ApiTypeHelper.requireNonNull(builder.nodes, this, "nodes");
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, this, "timestamp");
    }

    public static ClusterStatsResponse of(Function<Builder, ObjectBuilder<ClusterStatsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String clusterUuid() {
        return this.clusterUuid;
    }

    public final ClusterIndices indices() {
        return this.indices;
    }

    public final ClusterNodes nodes() {
        return this.nodes;
    }

    public final HealthStatus status() {
        return this.status;
    }

    public final long timestamp() {
        return this.timestamp;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("cluster_name");
        generator.write(this.clusterName);
        generator.writeKey("cluster_uuid");
        generator.write(this.clusterUuid);
        generator.writeKey("indices");
        this.indices.serialize(generator, mapper);
        generator.writeKey("nodes");
        this.nodes.serialize(generator, mapper);
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
    }

    protected static void setupClusterStatsResponseDeserializer(ObjectDeserializer<Builder> op) {
        NodesResponseBase.setupNodesResponseBaseDeserializer(op);
        op.add(Builder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name");
        op.add(Builder::clusterUuid, JsonpDeserializer.stringDeserializer(), "cluster_uuid");
        op.add(Builder::indices, ClusterIndices._DESERIALIZER, "indices");
        op.add(Builder::nodes, ClusterNodes._DESERIALIZER, "nodes");
        op.add(Builder::status, HealthStatus._DESERIALIZER, "status");
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp");
    }

    public static class Builder
    extends NodesResponseBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ClusterStatsResponse> {
        private String clusterName;
        private String clusterUuid;
        private ClusterIndices indices;
        private ClusterNodes nodes;
        private HealthStatus status;
        private Long timestamp;

        public final Builder clusterName(String value) {
            this.clusterName = value;
            return this;
        }

        public final Builder clusterUuid(String value) {
            this.clusterUuid = value;
            return this;
        }

        public final Builder indices(ClusterIndices value) {
            this.indices = value;
            return this;
        }

        public final Builder indices(Function<ClusterIndices.Builder, ObjectBuilder<ClusterIndices>> fn) {
            return this.indices(fn.apply(new ClusterIndices.Builder()).build());
        }

        public final Builder nodes(ClusterNodes value) {
            this.nodes = value;
            return this;
        }

        public final Builder nodes(Function<ClusterNodes.Builder, ObjectBuilder<ClusterNodes>> fn) {
            return this.nodes(fn.apply(new ClusterNodes.Builder()).build());
        }

        public final Builder status(HealthStatus value) {
            this.status = value;
            return this;
        }

        public final Builder timestamp(long value) {
            this.timestamp = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ClusterStatsResponse build() {
            this._checkSingleUse();
            return new ClusterStatsResponse(this);
        }
    }
}

