/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ThreadCount
implements JsonpSerializable {
    private final long active;
    private final long completed;
    private final long largest;
    private final long queue;
    private final long rejected;
    private final long threads;
    public static final JsonpDeserializer<ThreadCount> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ThreadCount::setupThreadCountDeserializer);

    private ThreadCount(Builder builder) {
        this.active = ApiTypeHelper.requireNonNull(builder.active, this, "active");
        this.completed = ApiTypeHelper.requireNonNull(builder.completed, this, "completed");
        this.largest = ApiTypeHelper.requireNonNull(builder.largest, this, "largest");
        this.queue = ApiTypeHelper.requireNonNull(builder.queue, this, "queue");
        this.rejected = ApiTypeHelper.requireNonNull(builder.rejected, this, "rejected");
        this.threads = ApiTypeHelper.requireNonNull(builder.threads, this, "threads");
    }

    public static ThreadCount of(Function<Builder, ObjectBuilder<ThreadCount>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long active() {
        return this.active;
    }

    public final long completed() {
        return this.completed;
    }

    public final long largest() {
        return this.largest;
    }

    public final long queue() {
        return this.queue;
    }

    public final long rejected() {
        return this.rejected;
    }

    public final long threads() {
        return this.threads;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("active");
        generator.write(this.active);
        generator.writeKey("completed");
        generator.write(this.completed);
        generator.writeKey("largest");
        generator.write(this.largest);
        generator.writeKey("queue");
        generator.write(this.queue);
        generator.writeKey("rejected");
        generator.write(this.rejected);
        generator.writeKey("threads");
        generator.write(this.threads);
    }

    protected static void setupThreadCountDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::active, JsonpDeserializer.longDeserializer(), "active");
        op.add(Builder::completed, JsonpDeserializer.longDeserializer(), "completed");
        op.add(Builder::largest, JsonpDeserializer.longDeserializer(), "largest");
        op.add(Builder::queue, JsonpDeserializer.longDeserializer(), "queue");
        op.add(Builder::rejected, JsonpDeserializer.longDeserializer(), "rejected");
        op.add(Builder::threads, JsonpDeserializer.longDeserializer(), "threads");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ThreadCount> {
        private Long active;
        private Long completed;
        private Long largest;
        private Long queue;
        private Long rejected;
        private Long threads;

        public final Builder active(long value) {
            this.active = value;
            return this;
        }

        public final Builder completed(long value) {
            this.completed = value;
            return this;
        }

        public final Builder largest(long value) {
            this.largest = value;
            return this;
        }

        public final Builder queue(long value) {
            this.queue = value;
            return this;
        }

        public final Builder rejected(long value) {
            this.rejected = value;
            return this;
        }

        public final Builder threads(long value) {
            this.threads = value;
            return this;
        }

        @Override
        public ThreadCount build() {
            this._checkSingleUse();
            return new ThreadCount(this);
        }
    }
}

