/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.update_aliases;

import co.elastic.clients.elasticsearch.indices.update_aliases.ActionVariant;
import co.elastic.clients.elasticsearch.indices.update_aliases.AddAction;
import co.elastic.clients.elasticsearch.indices.update_aliases.RemoveAction;
import co.elastic.clients.elasticsearch.indices.update_aliases.RemoveIndexAction;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Action
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<Action> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Action::setupActionDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public Action(ActionVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._actionKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private Action(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static Action of(Function<Builder, ObjectBuilder<Action>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isAdd() {
        return this._kind == Kind.Add;
    }

    public AddAction add() {
        return (AddAction)TaggedUnionUtils.get(this, Kind.Add);
    }

    public boolean isRemove() {
        return this._kind == Kind.Remove;
    }

    public RemoveAction remove() {
        return (RemoveAction)TaggedUnionUtils.get(this, Kind.Remove);
    }

    public boolean isRemoveIndex() {
        return this._kind == Kind.RemoveIndex;
    }

    public RemoveIndexAction removeIndex() {
        return (RemoveIndexAction)TaggedUnionUtils.get(this, Kind.RemoveIndex);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupActionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::add, AddAction._DESERIALIZER, "add");
        op.add(Builder::remove, RemoveAction._DESERIALIZER, "remove");
        op.add(Builder::removeIndex, RemoveIndexAction._DESERIALIZER, "remove_index");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Action> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<Action> add(AddAction v) {
            this._kind = Kind.Add;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Action> add(Function<AddAction.Builder, ObjectBuilder<AddAction>> fn) {
            return this.add(fn.apply(new AddAction.Builder()).build());
        }

        public ObjectBuilder<Action> remove(RemoveAction v) {
            this._kind = Kind.Remove;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Action> remove(Function<RemoveAction.Builder, ObjectBuilder<RemoveAction>> fn) {
            return this.remove(fn.apply(new RemoveAction.Builder()).build());
        }

        public ObjectBuilder<Action> removeIndex(RemoveIndexAction v) {
            this._kind = Kind.RemoveIndex;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Action> removeIndex(Function<RemoveIndexAction.Builder, ObjectBuilder<RemoveIndexAction>> fn) {
            return this.removeIndex(fn.apply(new RemoveIndexAction.Builder()).build());
        }

        @Override
        public Action build() {
            this._checkSingleUse();
            return new Action(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Add("add"),
        Remove("remove"),
        RemoveIndex("remove_index");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

