/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.MlDatafeedsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class MlDatafeedsRequest
extends CatRequestBase {
    @Nullable
    private final Boolean allowNoDatafeeds;
    @Nullable
    private final String datafeedId;
    public static final Endpoint<MlDatafeedsRequest, MlDatafeedsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<MlDatafeedsRequest, MlDatafeedsResponse>("es/cat.ml_datafeeds", request -> "GET", request -> {
        boolean _datafeedId = true;
        boolean propsSet = false;
        if (request.datafeedId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/ml");
            buf.append("/datafeeds");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/ml");
            buf.append("/datafeeds");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.datafeedId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (request.allowNoDatafeeds != null) {
            params.put("allow_no_datafeeds", String.valueOf(request.allowNoDatafeeds));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, MlDatafeedsResponse._DESERIALIZER);

    private MlDatafeedsRequest(Builder builder) {
        this.allowNoDatafeeds = builder.allowNoDatafeeds;
        this.datafeedId = builder.datafeedId;
    }

    public static MlDatafeedsRequest of(Function<Builder, ObjectBuilder<MlDatafeedsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Deprecated
    @Nullable
    public final Boolean allowNoDatafeeds() {
        return this.allowNoDatafeeds;
    }

    @Nullable
    public final String datafeedId() {
        return this.datafeedId;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<MlDatafeedsRequest> {
        @Nullable
        private Boolean allowNoDatafeeds;
        @Nullable
        private String datafeedId;

        @Deprecated
        public final Builder allowNoDatafeeds(@Nullable Boolean value) {
            this.allowNoDatafeeds = value;
            return this;
        }

        public final Builder datafeedId(@Nullable String value) {
            this.datafeedId = value;
            return this;
        }

        @Override
        public MlDatafeedsRequest build() {
            this._checkSingleUse();
            return new MlDatafeedsRequest(this);
        }
    }
}

