/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security.grant_api_key;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ApiKey
implements JsonpSerializable {
    private final String name;
    @Nullable
    private final Time expiration;
    private final List<Map<String, JsonData>> roleDescriptors;
    public static final JsonpDeserializer<ApiKey> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ApiKey::setupApiKeyDeserializer);

    private ApiKey(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.expiration = builder.expiration;
        this.roleDescriptors = ApiTypeHelper.unmodifiable(builder.roleDescriptors);
    }

    public static ApiKey of(Function<Builder, ObjectBuilder<ApiKey>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final Time expiration() {
        return this.expiration;
    }

    public final List<Map<String, JsonData>> roleDescriptors() {
        return this.roleDescriptors;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        if (this.expiration != null) {
            generator.writeKey("expiration");
            this.expiration.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.roleDescriptors)) {
            generator.writeKey("role_descriptors");
            generator.writeStartArray();
            for (Map<String, JsonData> item0 : this.roleDescriptors) {
                generator.writeStartObject();
                if (item0 != null) {
                    for (Map.Entry<String, JsonData> item1 : item0.entrySet()) {
                        generator.writeKey(item1.getKey());
                        item1.getValue().serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    protected static void setupApiKeyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::expiration, Time._DESERIALIZER, "expiration");
        op.add(Builder::roleDescriptors, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER)), "role_descriptors");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ApiKey> {
        private String name;
        @Nullable
        private Time expiration;
        @Nullable
        private List<Map<String, JsonData>> roleDescriptors;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder expiration(@Nullable Time value) {
            this.expiration = value;
            return this;
        }

        public final Builder expiration(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.expiration(fn.apply(new Time.Builder()).build());
        }

        public final Builder roleDescriptors(List<Map<String, JsonData>> list) {
            this.roleDescriptors = Builder._listAddAll(this.roleDescriptors, list);
            return this;
        }

        public final Builder roleDescriptors(Map<String, JsonData> value, Map<String, JsonData> ... values) {
            this.roleDescriptors = Builder._listAdd(this.roleDescriptors, value, values);
            return this;
        }

        @Override
        public ApiKey build() {
            this._checkSingleUse();
            return new ApiKey(this);
        }
    }
}

