/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetTrainedModelsStatsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class GetTrainedModelsStatsRequest
extends RequestBase {
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Integer from;
    @Nullable
    private final String modelId;
    @Nullable
    private final Integer size;
    public static final Endpoint<GetTrainedModelsStatsRequest, GetTrainedModelsStatsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetTrainedModelsStatsRequest, GetTrainedModelsStatsResponse>("es/ml.get_trained_models_stats", request -> "GET", request -> {
        boolean _modelId = true;
        boolean propsSet = false;
        if (request.modelId() != null) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            buf.append("/_stats");
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            buf.append("/_stats");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetTrainedModelsStatsResponse._DESERIALIZER);

    private GetTrainedModelsStatsRequest(Builder builder) {
        this.allowNoMatch = builder.allowNoMatch;
        this.from = builder.from;
        this.modelId = builder.modelId;
        this.size = builder.size;
    }

    public static GetTrainedModelsStatsRequest of(Function<Builder, ObjectBuilder<GetTrainedModelsStatsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    @Nullable
    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GetTrainedModelsStatsRequest> {
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Integer from;
        @Nullable
        private String modelId;
        @Nullable
        private Integer size;

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder modelId(@Nullable String value) {
            this.modelId = value;
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Override
        public GetTrainedModelsStatsRequest build() {
            this._checkSingleUse();
            return new GetTrainedModelsStatsRequest(this);
        }
    }
}

