/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.util;

import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.util.TriConsumer;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;

public class Union2<A, B> {
    private final Tag tag;
    private final Object value;

    private Union2(Tag tag, Object value) {
        this.tag = tag;
        this.value = value;
    }

    public static <A, B> Union2<A, B> ofA(A value) {
        return new Union2<A, B>(Tag.A, value);
    }

    public static <A, B> Union2<A, B> ofB(B value) {
        return new Union2<A, B>(Tag.B, value);
    }

    public Tag tag() {
        return this.tag;
    }

    public A a() {
        return (A)this.getVariant(Tag.A);
    }

    public B b() {
        return (B)this.getVariant(Tag.B);
    }

    private <T> T getVariant(Tag tag) {
        if (this.tag != tag) {
            throw new IllegalStateException("Union holds variant " + (Object)((Object)tag));
        }
        Object result = this.value;
        return (T)result;
    }

    public void serialize(JsonGenerator builder, JsonpMapper params, TriConsumer<A, JsonGenerator, JsonpMapper> a, TriConsumer<B, JsonGenerator, JsonpMapper> b) {
        switch (this.tag) {
            case A: {
                a.accept(this.a(), builder, params);
            }
            case B: {
                b.accept(this.b(), builder, params);
            }
        }
    }

    public static enum Tag {
        A,
        B;

    }

    public static class JsonpParser<A, B>
    extends JsonpDeserializer<Union2<A, B>> {
        private final JsonpDeserializer<A> parserA;
        private final JsonpDeserializer<B> parserB;

        public JsonpParser(JsonpDeserializer<A> parserA, JsonpDeserializer<B> parserB) {
            super(JsonpParser.allAcceptedEvents(parserA, parserB));
            this.parserA = parserA;
            this.parserB = parserB;
        }

        @Override
        public Union2<A, B> deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            if (this.parserA.accepts(event)) {
                return Union2.ofA(this.parserA.deserialize(parser, mapper, event));
            }
            if (this.parserB.accepts(event)) {
                return Union2.ofB(this.parserB.deserialize(parser, mapper, event));
            }
            throw new JsonParsingException("Unexpected event [" + event + "]", parser.getLocation());
        }
    }
}

