/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class WatcherActionTotals
implements JsonpSerializable {
    private final long total;
    private final long totalTimeInMs;
    public static final JsonpDeserializer<WatcherActionTotals> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WatcherActionTotals::setupWatcherActionTotalsDeserializer, Builder::build);

    public WatcherActionTotals(Builder builder) {
        this.total = Objects.requireNonNull(builder.total, "total");
        this.totalTimeInMs = Objects.requireNonNull(builder.totalTimeInMs, "total_time_in_ms");
    }

    public WatcherActionTotals(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long total() {
        return this.total;
    }

    public long totalTimeInMs() {
        return this.totalTimeInMs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("total_time_in_ms");
        generator.write(this.totalTimeInMs);
    }

    protected static void setupWatcherActionTotalsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total", new String[0]);
        op.add(Builder::totalTimeInMs, JsonpDeserializer.longDeserializer(), "total_time_in_ms", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<WatcherActionTotals> {
        private Long total;
        private Long totalTimeInMs;

        public Builder total(long value) {
            this.total = value;
            return this;
        }

        public Builder totalTimeInMs(long value) {
            this.totalTimeInMs = value;
            return this;
        }

        @Override
        public WatcherActionTotals build() {
            return new WatcherActionTotals(this);
        }
    }
}

