/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SecurityRolesDlsBitSetCache
implements JsonpSerializable {
    private final int count;
    @Nullable
    private final String memory;
    private final Number memoryInBytes;
    public static final JsonpDeserializer<SecurityRolesDlsBitSetCache> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SecurityRolesDlsBitSetCache::setupSecurityRolesDlsBitSetCacheDeserializer, Builder::build);

    public SecurityRolesDlsBitSetCache(Builder builder) {
        this.count = Objects.requireNonNull(builder.count, "count");
        this.memory = builder.memory;
        this.memoryInBytes = Objects.requireNonNull(builder.memoryInBytes, "memory_in_bytes");
    }

    public SecurityRolesDlsBitSetCache(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int count() {
        return this.count;
    }

    @Nullable
    public String memory() {
        return this.memory;
    }

    public Number memoryInBytes() {
        return this.memoryInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (this.memory != null) {
            generator.writeKey("memory");
            generator.write(this.memory);
        }
        generator.writeKey("memory_in_bytes");
        generator.write(this.memoryInBytes.doubleValue());
    }

    protected static void setupSecurityRolesDlsBitSetCacheDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count", new String[0]);
        op.add(Builder::memory, JsonpDeserializer.stringDeserializer(), "memory", new String[0]);
        op.add(Builder::memoryInBytes, JsonpDeserializer.numberDeserializer(), "memory_in_bytes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SecurityRolesDlsBitSetCache> {
        private Integer count;
        @Nullable
        private String memory;
        private Number memoryInBytes;

        public Builder count(int value) {
            this.count = value;
            return this;
        }

        public Builder memory(@Nullable String value) {
            this.memory = value;
            return this;
        }

        public Builder memoryInBytes(Number value) {
            this.memoryInBytes = value;
            return this;
        }

        @Override
        public SecurityRolesDlsBitSetCache build() {
            return new SecurityRolesDlsBitSetCache(this);
        }
    }
}

