/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.elasticsearch.xpack.usage.RuntimeFieldsType;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class RuntimeFieldTypes
extends Base {
    private final List<RuntimeFieldsType> fieldTypes;
    public static final JsonpDeserializer<RuntimeFieldTypes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RuntimeFieldTypes::setupRuntimeFieldTypesDeserializer, Builder::build);

    public RuntimeFieldTypes(Builder builder) {
        super(builder);
        this.fieldTypes = ModelTypeHelper.unmodifiableNonNull(builder.fieldTypes, "field_types");
    }

    public RuntimeFieldTypes(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<RuntimeFieldsType> fieldTypes() {
        return this.fieldTypes;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field_types");
        generator.writeStartArray();
        for (RuntimeFieldsType item0 : this.fieldTypes) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupRuntimeFieldTypesDeserializer(DelegatingDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::fieldTypes, JsonpDeserializer.arrayDeserializer(RuntimeFieldsType._DESERIALIZER), "field_types", new String[0]);
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<RuntimeFieldTypes> {
        private List<RuntimeFieldsType> fieldTypes;

        public Builder fieldTypes(List<RuntimeFieldsType> value) {
            this.fieldTypes = value;
            return this;
        }

        public Builder fieldTypes(RuntimeFieldsType ... value) {
            this.fieldTypes = Arrays.asList(value);
            return this;
        }

        public Builder addFieldTypes(RuntimeFieldsType value) {
            if (this.fieldTypes == null) {
                this.fieldTypes = new ArrayList<RuntimeFieldsType>();
            }
            this.fieldTypes.add(value);
            return this;
        }

        public Builder fieldTypes(Function<RuntimeFieldsType.Builder, ObjectBuilder<RuntimeFieldsType>> fn) {
            return this.fieldTypes(fn.apply(new RuntimeFieldsType.Builder()).build());
        }

        public Builder addFieldTypes(Function<RuntimeFieldsType.Builder, ObjectBuilder<RuntimeFieldsType>> fn) {
            return this.addFieldTypes(fn.apply(new RuntimeFieldsType.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RuntimeFieldTypes build() {
            return new RuntimeFieldTypes(this);
        }
    }
}

