/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;

@JsonpDeserializable
public class Base
implements JsonpSerializable {
    private final boolean available;
    private final boolean enabled;
    public static final JsonpDeserializer<Base> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Base::setupBaseDeserializer, Builder::build);

    public Base(AbstractBuilder<?> builder) {
        this.available = Objects.requireNonNull(((AbstractBuilder)builder).available, "available");
        this.enabled = Objects.requireNonNull(((AbstractBuilder)builder).enabled, "enabled");
    }

    public boolean available() {
        return this.available;
    }

    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("available");
        generator.write(this.available);
        generator.writeKey("enabled");
        generator.write(this.enabled);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupBaseDeserializer(DelegatingDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::available, JsonpDeserializer.booleanDeserializer(), "available", new String[0]);
        op.add(AbstractBuilder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>> {
        private Boolean available;
        private Boolean enabled;

        protected AbstractBuilder() {
        }

        public BuilderT available(boolean value) {
            this.available = value;
            return this.self();
        }

        public BuilderT enabled(boolean value) {
            this.enabled = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<Base> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Base build() {
            return new Base(this);
        }
    }
}

