/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class AnalyticsStatistics
implements JsonpSerializable {
    private final long boxplotUsage;
    private final long cumulativeCardinalityUsage;
    private final long stringStatsUsage;
    private final long topMetricsUsage;
    private final long tTestUsage;
    private final long movingPercentilesUsage;
    private final long normalizeUsage;
    private final long rateUsage;
    @Nullable
    private final Long multiTermsUsage;
    public static final JsonpDeserializer<AnalyticsStatistics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AnalyticsStatistics::setupAnalyticsStatisticsDeserializer, Builder::build);

    public AnalyticsStatistics(Builder builder) {
        this.boxplotUsage = Objects.requireNonNull(builder.boxplotUsage, "boxplot_usage");
        this.cumulativeCardinalityUsage = Objects.requireNonNull(builder.cumulativeCardinalityUsage, "cumulative_cardinality_usage");
        this.stringStatsUsage = Objects.requireNonNull(builder.stringStatsUsage, "string_stats_usage");
        this.topMetricsUsage = Objects.requireNonNull(builder.topMetricsUsage, "top_metrics_usage");
        this.tTestUsage = Objects.requireNonNull(builder.tTestUsage, "t_test_usage");
        this.movingPercentilesUsage = Objects.requireNonNull(builder.movingPercentilesUsage, "moving_percentiles_usage");
        this.normalizeUsage = Objects.requireNonNull(builder.normalizeUsage, "normalize_usage");
        this.rateUsage = Objects.requireNonNull(builder.rateUsage, "rate_usage");
        this.multiTermsUsage = builder.multiTermsUsage;
    }

    public AnalyticsStatistics(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long boxplotUsage() {
        return this.boxplotUsage;
    }

    public long cumulativeCardinalityUsage() {
        return this.cumulativeCardinalityUsage;
    }

    public long stringStatsUsage() {
        return this.stringStatsUsage;
    }

    public long topMetricsUsage() {
        return this.topMetricsUsage;
    }

    public long tTestUsage() {
        return this.tTestUsage;
    }

    public long movingPercentilesUsage() {
        return this.movingPercentilesUsage;
    }

    public long normalizeUsage() {
        return this.normalizeUsage;
    }

    public long rateUsage() {
        return this.rateUsage;
    }

    @Nullable
    public Long multiTermsUsage() {
        return this.multiTermsUsage;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("boxplot_usage");
        generator.write(this.boxplotUsage);
        generator.writeKey("cumulative_cardinality_usage");
        generator.write(this.cumulativeCardinalityUsage);
        generator.writeKey("string_stats_usage");
        generator.write(this.stringStatsUsage);
        generator.writeKey("top_metrics_usage");
        generator.write(this.topMetricsUsage);
        generator.writeKey("t_test_usage");
        generator.write(this.tTestUsage);
        generator.writeKey("moving_percentiles_usage");
        generator.write(this.movingPercentilesUsage);
        generator.writeKey("normalize_usage");
        generator.write(this.normalizeUsage);
        generator.writeKey("rate_usage");
        generator.write(this.rateUsage);
        if (this.multiTermsUsage != null) {
            generator.writeKey("multi_terms_usage");
            generator.write(this.multiTermsUsage.longValue());
        }
    }

    protected static void setupAnalyticsStatisticsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::boxplotUsage, JsonpDeserializer.longDeserializer(), "boxplot_usage", new String[0]);
        op.add(Builder::cumulativeCardinalityUsage, JsonpDeserializer.longDeserializer(), "cumulative_cardinality_usage", new String[0]);
        op.add(Builder::stringStatsUsage, JsonpDeserializer.longDeserializer(), "string_stats_usage", new String[0]);
        op.add(Builder::topMetricsUsage, JsonpDeserializer.longDeserializer(), "top_metrics_usage", new String[0]);
        op.add(Builder::tTestUsage, JsonpDeserializer.longDeserializer(), "t_test_usage", new String[0]);
        op.add(Builder::movingPercentilesUsage, JsonpDeserializer.longDeserializer(), "moving_percentiles_usage", new String[0]);
        op.add(Builder::normalizeUsage, JsonpDeserializer.longDeserializer(), "normalize_usage", new String[0]);
        op.add(Builder::rateUsage, JsonpDeserializer.longDeserializer(), "rate_usage", new String[0]);
        op.add(Builder::multiTermsUsage, JsonpDeserializer.longDeserializer(), "multi_terms_usage", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<AnalyticsStatistics> {
        private Long boxplotUsage;
        private Long cumulativeCardinalityUsage;
        private Long stringStatsUsage;
        private Long topMetricsUsage;
        private Long tTestUsage;
        private Long movingPercentilesUsage;
        private Long normalizeUsage;
        private Long rateUsage;
        @Nullable
        private Long multiTermsUsage;

        public Builder boxplotUsage(long value) {
            this.boxplotUsage = value;
            return this;
        }

        public Builder cumulativeCardinalityUsage(long value) {
            this.cumulativeCardinalityUsage = value;
            return this;
        }

        public Builder stringStatsUsage(long value) {
            this.stringStatsUsage = value;
            return this;
        }

        public Builder topMetricsUsage(long value) {
            this.topMetricsUsage = value;
            return this;
        }

        public Builder tTestUsage(long value) {
            this.tTestUsage = value;
            return this;
        }

        public Builder movingPercentilesUsage(long value) {
            this.movingPercentilesUsage = value;
            return this;
        }

        public Builder normalizeUsage(long value) {
            this.normalizeUsage = value;
            return this;
        }

        public Builder rateUsage(long value) {
            this.rateUsage = value;
            return this;
        }

        public Builder multiTermsUsage(@Nullable Long value) {
            this.multiTermsUsage = value;
            return this;
        }

        @Override
        public AnalyticsStatistics build() {
            return new AnalyticsStatistics(this);
        }
    }
}

