/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.info;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class NativeCodeInformation
implements JsonpSerializable {
    private final String buildHash;
    private final String version;
    public static final JsonpDeserializer<NativeCodeInformation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NativeCodeInformation::setupNativeCodeInformationDeserializer, Builder::build);

    public NativeCodeInformation(Builder builder) {
        this.buildHash = Objects.requireNonNull(builder.buildHash, "build_hash");
        this.version = Objects.requireNonNull(builder.version, "version");
    }

    public NativeCodeInformation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String buildHash() {
        return this.buildHash;
    }

    public String version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("build_hash");
        generator.write(this.buildHash);
        generator.writeKey("version");
        generator.write(this.version);
    }

    protected static void setupNativeCodeInformationDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::buildHash, JsonpDeserializer.stringDeserializer(), "build_hash", new String[0]);
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NativeCodeInformation> {
        private String buildHash;
        private String version;

        public Builder buildHash(String value) {
            this.buildHash = value;
            return this;
        }

        public Builder version(String value) {
            this.version = value;
            return this;
        }

        @Override
        public NativeCodeInformation build() {
            return new NativeCodeInformation(this);
        }
    }
}

