/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher.stats;

import co.elastic.clients.elasticsearch.watcher.ExecutionThreadPool;
import co.elastic.clients.elasticsearch.watcher.stats.WatchRecordQueuedStats;
import co.elastic.clients.elasticsearch.watcher.stats.WatchRecordStats;
import co.elastic.clients.elasticsearch.watcher.stats.WatcherState;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class WatcherNodeStats
implements JsonpSerializable {
    @Nullable
    private final List<WatchRecordStats> currentWatches;
    private final ExecutionThreadPool executionThreadPool;
    @Nullable
    private final List<WatchRecordQueuedStats> queuedWatches;
    private final long watchCount;
    private final WatcherState watcherState;
    private final String nodeId;
    public static final JsonpDeserializer<WatcherNodeStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WatcherNodeStats::setupWatcherNodeStatsDeserializer, Builder::build);

    public WatcherNodeStats(Builder builder) {
        this.currentWatches = ModelTypeHelper.unmodifiable(builder.currentWatches);
        this.executionThreadPool = Objects.requireNonNull(builder.executionThreadPool, "execution_thread_pool");
        this.queuedWatches = ModelTypeHelper.unmodifiable(builder.queuedWatches);
        this.watchCount = Objects.requireNonNull(builder.watchCount, "watch_count");
        this.watcherState = Objects.requireNonNull(builder.watcherState, "watcher_state");
        this.nodeId = Objects.requireNonNull(builder.nodeId, "node_id");
    }

    public WatcherNodeStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<WatchRecordStats> currentWatches() {
        return this.currentWatches;
    }

    public ExecutionThreadPool executionThreadPool() {
        return this.executionThreadPool;
    }

    @Nullable
    public List<WatchRecordQueuedStats> queuedWatches() {
        return this.queuedWatches;
    }

    public long watchCount() {
        return this.watchCount;
    }

    public WatcherState watcherState() {
        return this.watcherState;
    }

    public String nodeId() {
        return this.nodeId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.currentWatches != null) {
            generator.writeKey("current_watches");
            generator.writeStartArray();
            for (WatchRecordStats watchRecordStats : this.currentWatches) {
                watchRecordStats.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("execution_thread_pool");
        this.executionThreadPool.serialize(generator, mapper);
        if (this.queuedWatches != null) {
            generator.writeKey("queued_watches");
            generator.writeStartArray();
            for (WatchRecordQueuedStats watchRecordQueuedStats : this.queuedWatches) {
                watchRecordQueuedStats.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("watch_count");
        generator.write(this.watchCount);
        generator.writeKey("watcher_state");
        this.watcherState.serialize(generator, mapper);
        generator.writeKey("node_id");
        generator.write(this.nodeId);
    }

    protected static void setupWatcherNodeStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::currentWatches, JsonpDeserializer.arrayDeserializer(WatchRecordStats._DESERIALIZER), "current_watches", new String[0]);
        op.add(Builder::executionThreadPool, ExecutionThreadPool._DESERIALIZER, "execution_thread_pool", new String[0]);
        op.add(Builder::queuedWatches, JsonpDeserializer.arrayDeserializer(WatchRecordQueuedStats._DESERIALIZER), "queued_watches", new String[0]);
        op.add(Builder::watchCount, JsonpDeserializer.longDeserializer(), "watch_count", new String[0]);
        op.add(Builder::watcherState, WatcherState._DESERIALIZER, "watcher_state", new String[0]);
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node_id", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<WatcherNodeStats> {
        @Nullable
        private List<WatchRecordStats> currentWatches;
        private ExecutionThreadPool executionThreadPool;
        @Nullable
        private List<WatchRecordQueuedStats> queuedWatches;
        private Long watchCount;
        private WatcherState watcherState;
        private String nodeId;

        public Builder currentWatches(@Nullable List<WatchRecordStats> value) {
            this.currentWatches = value;
            return this;
        }

        public Builder currentWatches(WatchRecordStats ... value) {
            this.currentWatches = Arrays.asList(value);
            return this;
        }

        public Builder addCurrentWatches(WatchRecordStats value) {
            if (this.currentWatches == null) {
                this.currentWatches = new ArrayList<WatchRecordStats>();
            }
            this.currentWatches.add(value);
            return this;
        }

        public Builder currentWatches(Function<WatchRecordStats.Builder, ObjectBuilder<WatchRecordStats>> fn) {
            return this.currentWatches(fn.apply(new WatchRecordStats.Builder()).build());
        }

        public Builder addCurrentWatches(Function<WatchRecordStats.Builder, ObjectBuilder<WatchRecordStats>> fn) {
            return this.addCurrentWatches(fn.apply(new WatchRecordStats.Builder()).build());
        }

        public Builder executionThreadPool(ExecutionThreadPool value) {
            this.executionThreadPool = value;
            return this;
        }

        public Builder executionThreadPool(Function<ExecutionThreadPool.Builder, ObjectBuilder<ExecutionThreadPool>> fn) {
            return this.executionThreadPool(fn.apply(new ExecutionThreadPool.Builder()).build());
        }

        public Builder queuedWatches(@Nullable List<WatchRecordQueuedStats> value) {
            this.queuedWatches = value;
            return this;
        }

        public Builder queuedWatches(WatchRecordQueuedStats ... value) {
            this.queuedWatches = Arrays.asList(value);
            return this;
        }

        public Builder addQueuedWatches(WatchRecordQueuedStats value) {
            if (this.queuedWatches == null) {
                this.queuedWatches = new ArrayList<WatchRecordQueuedStats>();
            }
            this.queuedWatches.add(value);
            return this;
        }

        public Builder queuedWatches(Function<WatchRecordQueuedStats.Builder, ObjectBuilder<WatchRecordQueuedStats>> fn) {
            return this.queuedWatches(fn.apply(new WatchRecordQueuedStats.Builder()).build());
        }

        public Builder addQueuedWatches(Function<WatchRecordQueuedStats.Builder, ObjectBuilder<WatchRecordQueuedStats>> fn) {
            return this.addQueuedWatches(fn.apply(new WatchRecordQueuedStats.Builder()).build());
        }

        public Builder watchCount(long value) {
            this.watchCount = value;
            return this;
        }

        public Builder watcherState(WatcherState value) {
            this.watcherState = value;
            return this;
        }

        public Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        @Override
        public WatcherNodeStats build() {
            return new WatcherNodeStats(this);
        }
    }
}

