/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch._types.NodeStatistics;
import co.elastic.clients.elasticsearch.watcher.stats.WatcherNodeStats;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class StatsResponse
implements JsonpSerializable {
    private final NodeStatistics nodeStats;
    private final String clusterName;
    private final boolean manuallyStopped;
    private final List<WatcherNodeStats> stats;
    public static final JsonpDeserializer<StatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StatsResponse::setupStatsResponseDeserializer, Builder::build);

    public StatsResponse(Builder builder) {
        this.nodeStats = Objects.requireNonNull(builder.nodeStats, "_nodes");
        this.clusterName = Objects.requireNonNull(builder.clusterName, "cluster_name");
        this.manuallyStopped = Objects.requireNonNull(builder.manuallyStopped, "manually_stopped");
        this.stats = ModelTypeHelper.unmodifiableNonNull(builder.stats, "stats");
    }

    public StatsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public NodeStatistics nodeStats() {
        return this.nodeStats;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public boolean manuallyStopped() {
        return this.manuallyStopped;
    }

    public List<WatcherNodeStats> stats() {
        return this.stats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_nodes");
        this.nodeStats.serialize(generator, mapper);
        generator.writeKey("cluster_name");
        generator.write(this.clusterName);
        generator.writeKey("manually_stopped");
        generator.write(this.manuallyStopped);
        generator.writeKey("stats");
        generator.writeStartArray();
        for (WatcherNodeStats item0 : this.stats) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupStatsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::nodeStats, NodeStatistics._DESERIALIZER, "_nodes", new String[0]);
        op.add(Builder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name", new String[0]);
        op.add(Builder::manuallyStopped, JsonpDeserializer.booleanDeserializer(), "manually_stopped", new String[0]);
        op.add(Builder::stats, JsonpDeserializer.arrayDeserializer(WatcherNodeStats._DESERIALIZER), "stats", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<StatsResponse> {
        private NodeStatistics nodeStats;
        private String clusterName;
        private Boolean manuallyStopped;
        private List<WatcherNodeStats> stats;

        public Builder nodeStats(NodeStatistics value) {
            this.nodeStats = value;
            return this;
        }

        public Builder nodeStats(Function<NodeStatistics.Builder, ObjectBuilder<NodeStatistics>> fn) {
            return this.nodeStats(fn.apply(new NodeStatistics.Builder()).build());
        }

        public Builder clusterName(String value) {
            this.clusterName = value;
            return this;
        }

        public Builder manuallyStopped(boolean value) {
            this.manuallyStopped = value;
            return this;
        }

        public Builder stats(List<WatcherNodeStats> value) {
            this.stats = value;
            return this;
        }

        public Builder stats(WatcherNodeStats ... value) {
            this.stats = Arrays.asList(value);
            return this;
        }

        public Builder addStats(WatcherNodeStats value) {
            if (this.stats == null) {
                this.stats = new ArrayList<WatcherNodeStats>();
            }
            this.stats.add(value);
            return this;
        }

        public Builder stats(Function<WatcherNodeStats.Builder, ObjectBuilder<WatcherNodeStats>> fn) {
            return this.stats(fn.apply(new WatcherNodeStats.Builder()).build());
        }

        public Builder addStats(Function<WatcherNodeStats.Builder, ObjectBuilder<WatcherNodeStats>> fn) {
            return this.addStats(fn.apply(new WatcherNodeStats.Builder()).build());
        }

        @Override
        public StatsResponse build() {
            return new StatsResponse(this);
        }
    }
}

