/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.SlackMessage;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SlackResult
implements JsonpSerializable {
    @Nullable
    private final String account;
    private final SlackMessage message;
    public static final JsonpDeserializer<SlackResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SlackResult::setupSlackResultDeserializer, Builder::build);

    public SlackResult(Builder builder) {
        this.account = builder.account;
        this.message = Objects.requireNonNull(builder.message, "message");
    }

    public SlackResult(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String account() {
        return this.account;
    }

    public SlackMessage message() {
        return this.message;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.account != null) {
            generator.writeKey("account");
            generator.write(this.account);
        }
        generator.writeKey("message");
        this.message.serialize(generator, mapper);
    }

    protected static void setupSlackResultDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::account, JsonpDeserializer.stringDeserializer(), "account", new String[0]);
        op.add(Builder::message, SlackMessage._DESERIALIZER, "message", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SlackResult> {
        @Nullable
        private String account;
        private SlackMessage message;

        public Builder account(@Nullable String value) {
            this.account = value;
            return this;
        }

        public Builder message(SlackMessage value) {
            this.message = value;
            return this;
        }

        public Builder message(Function<SlackMessage.Builder, ObjectBuilder<SlackMessage>> fn) {
            return this.message(fn.apply(new SlackMessage.Builder()).build());
        }

        @Override
        public SlackResult build() {
            return new SlackResult(this);
        }
    }
}

