/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.SlackAttachment;
import co.elastic.clients.elasticsearch.watcher.SlackDynamicAttachment;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SlackMessage
implements JsonpSerializable {
    private final List<SlackAttachment> attachments;
    @Nullable
    private final SlackDynamicAttachment dynamicAttachments;
    private final String from;
    @Nullable
    private final String icon;
    private final String text;
    private final List<String> to;
    public static final JsonpDeserializer<SlackMessage> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SlackMessage::setupSlackMessageDeserializer, Builder::build);

    public SlackMessage(Builder builder) {
        this.attachments = ModelTypeHelper.unmodifiableNonNull(builder.attachments, "attachments");
        this.dynamicAttachments = builder.dynamicAttachments;
        this.from = Objects.requireNonNull(builder.from, "from");
        this.icon = builder.icon;
        this.text = Objects.requireNonNull(builder.text, "text");
        this.to = ModelTypeHelper.unmodifiableNonNull(builder.to, "to");
    }

    public SlackMessage(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<SlackAttachment> attachments() {
        return this.attachments;
    }

    @Nullable
    public SlackDynamicAttachment dynamicAttachments() {
        return this.dynamicAttachments;
    }

    public String from() {
        return this.from;
    }

    @Nullable
    public String icon() {
        return this.icon;
    }

    public String text() {
        return this.text;
    }

    public List<String> to() {
        return this.to;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("attachments");
        generator.writeStartArray();
        for (SlackAttachment slackAttachment : this.attachments) {
            slackAttachment.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.dynamicAttachments != null) {
            generator.writeKey("dynamic_attachments");
            this.dynamicAttachments.serialize(generator, mapper);
        }
        generator.writeKey("from");
        generator.write(this.from);
        if (this.icon != null) {
            generator.writeKey("icon");
            generator.write(this.icon);
        }
        generator.writeKey("text");
        generator.write(this.text);
        generator.writeKey("to");
        generator.writeStartArray();
        for (String string : this.to) {
            generator.write(string);
        }
        generator.writeEnd();
    }

    protected static void setupSlackMessageDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::attachments, JsonpDeserializer.arrayDeserializer(SlackAttachment._DESERIALIZER), "attachments", new String[0]);
        op.add(Builder::dynamicAttachments, SlackDynamicAttachment._DESERIALIZER, "dynamic_attachments", new String[0]);
        op.add(Builder::from, JsonpDeserializer.stringDeserializer(), "from", new String[0]);
        op.add(Builder::icon, JsonpDeserializer.stringDeserializer(), "icon", new String[0]);
        op.add(Builder::text, JsonpDeserializer.stringDeserializer(), "text", new String[0]);
        op.add(Builder::to, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "to", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SlackMessage> {
        private List<SlackAttachment> attachments;
        @Nullable
        private SlackDynamicAttachment dynamicAttachments;
        private String from;
        @Nullable
        private String icon;
        private String text;
        private List<String> to;

        public Builder attachments(List<SlackAttachment> value) {
            this.attachments = value;
            return this;
        }

        public Builder attachments(SlackAttachment ... value) {
            this.attachments = Arrays.asList(value);
            return this;
        }

        public Builder addAttachments(SlackAttachment value) {
            if (this.attachments == null) {
                this.attachments = new ArrayList<SlackAttachment>();
            }
            this.attachments.add(value);
            return this;
        }

        public Builder attachments(Function<SlackAttachment.Builder, ObjectBuilder<SlackAttachment>> fn) {
            return this.attachments(fn.apply(new SlackAttachment.Builder()).build());
        }

        public Builder addAttachments(Function<SlackAttachment.Builder, ObjectBuilder<SlackAttachment>> fn) {
            return this.addAttachments(fn.apply(new SlackAttachment.Builder()).build());
        }

        public Builder dynamicAttachments(@Nullable SlackDynamicAttachment value) {
            this.dynamicAttachments = value;
            return this;
        }

        public Builder dynamicAttachments(Function<SlackDynamicAttachment.Builder, ObjectBuilder<SlackDynamicAttachment>> fn) {
            return this.dynamicAttachments(fn.apply(new SlackDynamicAttachment.Builder()).build());
        }

        public Builder from(String value) {
            this.from = value;
            return this;
        }

        public Builder icon(@Nullable String value) {
            this.icon = value;
            return this;
        }

        public Builder text(String value) {
            this.text = value;
            return this;
        }

        public Builder to(List<String> value) {
            this.to = value;
            return this;
        }

        public Builder to(String ... value) {
            this.to = Arrays.asList(value);
            return this;
        }

        public Builder addTo(String value) {
            if (this.to == null) {
                this.to = new ArrayList<String>();
            }
            this.to.add(value);
            return this;
        }

        @Override
        public SlackMessage build() {
            return new SlackMessage(this);
        }
    }
}

