/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch._core.SearchTemplateRequest;
import co.elastic.clients.elasticsearch._types.SearchType;
import co.elastic.clients.elasticsearch.watcher.IndicesOptions;
import co.elastic.clients.elasticsearch.watcher.SearchInputRequestBody;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SearchInputRequestDefinition
implements JsonpSerializable {
    @Nullable
    private final SearchInputRequestBody body;
    @Nullable
    private final List<String> indices;
    @Nullable
    private final IndicesOptions indicesOptions;
    @Nullable
    private final SearchType searchType;
    @Nullable
    private final SearchTemplateRequest template;
    @Nullable
    private final Boolean restTotalHitsAsInt;
    public static final JsonpDeserializer<SearchInputRequestDefinition> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchInputRequestDefinition::setupSearchInputRequestDefinitionDeserializer, Builder::build);

    public SearchInputRequestDefinition(Builder builder) {
        this.body = builder.body;
        this.indices = ModelTypeHelper.unmodifiable(builder.indices);
        this.indicesOptions = builder.indicesOptions;
        this.searchType = builder.searchType;
        this.template = builder.template;
        this.restTotalHitsAsInt = builder.restTotalHitsAsInt;
    }

    public SearchInputRequestDefinition(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public SearchInputRequestBody body() {
        return this.body;
    }

    @Nullable
    public List<String> indices() {
        return this.indices;
    }

    @Nullable
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    @Nullable
    public SearchType searchType() {
        return this.searchType;
    }

    @Nullable
    public SearchTemplateRequest template() {
        return this.template;
    }

    @Nullable
    public Boolean restTotalHitsAsInt() {
        return this.restTotalHitsAsInt;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.body != null) {
            generator.writeKey("body");
            this.body.serialize(generator, mapper);
        }
        if (this.indices != null) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String item0 : this.indices) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.indicesOptions != null) {
            generator.writeKey("indices_options");
            this.indicesOptions.serialize(generator, mapper);
        }
        if (this.searchType != null) {
            generator.writeKey("search_type");
            this.searchType.serialize(generator, mapper);
        }
        if (this.template != null) {
            generator.writeKey("template");
            this.template.serialize(generator, mapper);
        }
        if (this.restTotalHitsAsInt != null) {
            generator.writeKey("rest_total_hits_as_int");
            generator.write(this.restTotalHitsAsInt.booleanValue());
        }
    }

    protected static void setupSearchInputRequestDefinitionDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::body, SearchInputRequestBody._DESERIALIZER, "body", new String[0]);
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices", new String[0]);
        op.add(Builder::indicesOptions, IndicesOptions._DESERIALIZER, "indices_options", new String[0]);
        op.add(Builder::searchType, SearchType._DESERIALIZER, "search_type", new String[0]);
        op.add(Builder::template, SearchTemplateRequest._DESERIALIZER, "template", new String[0]);
        op.add(Builder::restTotalHitsAsInt, JsonpDeserializer.booleanDeserializer(), "rest_total_hits_as_int", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SearchInputRequestDefinition> {
        @Nullable
        private SearchInputRequestBody body;
        @Nullable
        private List<String> indices;
        @Nullable
        private IndicesOptions indicesOptions;
        @Nullable
        private SearchType searchType;
        @Nullable
        private SearchTemplateRequest template;
        @Nullable
        private Boolean restTotalHitsAsInt;

        public Builder body(@Nullable SearchInputRequestBody value) {
            this.body = value;
            return this;
        }

        public Builder body(Function<SearchInputRequestBody.Builder, ObjectBuilder<SearchInputRequestBody>> fn) {
            return this.body(fn.apply(new SearchInputRequestBody.Builder()).build());
        }

        public Builder indices(@Nullable List<String> value) {
            this.indices = value;
            return this;
        }

        public Builder indices(String ... value) {
            this.indices = Arrays.asList(value);
            return this;
        }

        public Builder addIndices(String value) {
            if (this.indices == null) {
                this.indices = new ArrayList<String>();
            }
            this.indices.add(value);
            return this;
        }

        public Builder indicesOptions(@Nullable IndicesOptions value) {
            this.indicesOptions = value;
            return this;
        }

        public Builder indicesOptions(Function<IndicesOptions.Builder, ObjectBuilder<IndicesOptions>> fn) {
            return this.indicesOptions(fn.apply(new IndicesOptions.Builder()).build());
        }

        public Builder searchType(@Nullable SearchType value) {
            this.searchType = value;
            return this;
        }

        public Builder template(@Nullable SearchTemplateRequest value) {
            this.template = value;
            return this;
        }

        public Builder template(Function<SearchTemplateRequest.Builder, ObjectBuilder<SearchTemplateRequest>> fn) {
            return this.template(fn.apply(new SearchTemplateRequest.Builder()).build());
        }

        public Builder restTotalHitsAsInt(@Nullable Boolean value) {
            this.restTotalHitsAsInt = value;
            return this;
        }

        @Override
        public SearchInputRequestDefinition build() {
            return new SearchInputRequestDefinition(this);
        }
    }
}

