/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Transform;
import co.elastic.clients.elasticsearch.watcher.Action;
import co.elastic.clients.elasticsearch.watcher.Condition;
import co.elastic.clients.elasticsearch.watcher.Input;
import co.elastic.clients.elasticsearch.watcher.PutWatchResponse;
import co.elastic.clients.elasticsearch.watcher.Trigger;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PutWatchRequest
extends RequestBase
implements JsonpSerializable {
    private final String id;
    @Nullable
    private final Boolean active;
    @Nullable
    private final Long ifPrimaryTerm;
    @Nullable
    private final Long ifSequenceNumber;
    @Nullable
    private final Long version;
    @Nullable
    private final Map<String, Action> actions;
    @Nullable
    private final Condition condition;
    @Nullable
    private final Input input;
    @Nullable
    private final Map<String, JsonData> metadata;
    @Nullable
    private final String throttlePeriod;
    @Nullable
    private final Transform transform;
    @Nullable
    private final Trigger trigger;
    public static final JsonpDeserializer<PutWatchRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutWatchRequest::setupPutWatchRequestDeserializer, Builder::build);
    public static final Endpoint<PutWatchRequest, PutWatchResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutWatchRequest, PutWatchResponse>(request -> "PUT", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_watcher");
            buf.append("/watch");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.active != null) {
            params.put("active", String.valueOf(request.active));
        }
        if (request.ifPrimaryTerm != null) {
            params.put("if_primary_term", String.valueOf(request.ifPrimaryTerm));
        }
        if (request.ifSequenceNumber != null) {
            params.put("if_sequence_number", String.valueOf(request.ifSequenceNumber));
        }
        if (request.version != null) {
            params.put("version", String.valueOf(request.version));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutWatchResponse._DESERIALIZER);

    public PutWatchRequest(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.active = builder.active;
        this.ifPrimaryTerm = builder.ifPrimaryTerm;
        this.ifSequenceNumber = builder.ifSequenceNumber;
        this.version = builder.version;
        this.actions = ModelTypeHelper.unmodifiable(builder.actions);
        this.condition = builder.condition;
        this.input = builder.input;
        this.metadata = ModelTypeHelper.unmodifiable(builder.metadata);
        this.throttlePeriod = builder.throttlePeriod;
        this.transform = builder.transform;
        this.trigger = builder.trigger;
    }

    public PutWatchRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public Boolean active() {
        return this.active;
    }

    @Nullable
    public Long ifPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    @Nullable
    public Long ifSequenceNumber() {
        return this.ifSequenceNumber;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Nullable
    public Map<String, Action> actions() {
        return this.actions;
    }

    @Nullable
    public Condition condition() {
        return this.condition;
    }

    @Nullable
    public Input input() {
        return this.input;
    }

    @Nullable
    public Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Nullable
    public String throttlePeriod() {
        return this.throttlePeriod;
    }

    @Nullable
    public Transform transform() {
        return this.transform;
    }

    @Nullable
    public Trigger trigger() {
        return this.trigger;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.actions != null) {
            generator.writeKey("actions");
            generator.writeStartObject();
            for (Map.Entry<String, Action> entry : this.actions.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.condition != null) {
            generator.writeKey("condition");
            this.condition.serialize(generator, mapper);
        }
        if (this.input != null) {
            generator.writeKey("input");
            this.input.serialize(generator, mapper);
        }
        if (this.metadata != null) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.metadata.entrySet()) {
                generator.writeKey(entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.throttlePeriod != null) {
            generator.writeKey("throttle_period");
            generator.write(this.throttlePeriod);
        }
        if (this.transform != null) {
            generator.writeKey("transform");
            this.transform.serialize(generator, mapper);
        }
        if (this.trigger != null) {
            generator.writeKey("trigger");
            this.trigger.serialize(generator, mapper);
        }
    }

    protected static void setupPutWatchRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::actions, JsonpDeserializer.stringMapDeserializer(Action._DESERIALIZER), "actions", new String[0]);
        op.add(Builder::condition, Condition._DESERIALIZER, "condition", new String[0]);
        op.add(Builder::input, Input._DESERIALIZER, "input", new String[0]);
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata", new String[0]);
        op.add(Builder::throttlePeriod, JsonpDeserializer.stringDeserializer(), "throttle_period", new String[0]);
        op.add(Builder::transform, Transform._DESERIALIZER, "transform", new String[0]);
        op.add(Builder::trigger, Trigger._DESERIALIZER, "trigger", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PutWatchRequest> {
        private String id;
        @Nullable
        private Boolean active;
        @Nullable
        private Long ifPrimaryTerm;
        @Nullable
        private Long ifSequenceNumber;
        @Nullable
        private Long version;
        @Nullable
        private Map<String, Action> actions;
        @Nullable
        private Condition condition;
        @Nullable
        private Input input;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private String throttlePeriod;
        @Nullable
        private Transform transform;
        @Nullable
        private Trigger trigger;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder active(@Nullable Boolean value) {
            this.active = value;
            return this;
        }

        public Builder ifPrimaryTerm(@Nullable Long value) {
            this.ifPrimaryTerm = value;
            return this;
        }

        public Builder ifSequenceNumber(@Nullable Long value) {
            this.ifSequenceNumber = value;
            return this;
        }

        public Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public Builder actions(@Nullable Map<String, Action> value) {
            this.actions = value;
            return this;
        }

        public Builder putActions(String key, Action value) {
            if (this.actions == null) {
                this.actions = new HashMap<String, Action>();
            }
            this.actions.put(key, value);
            return this;
        }

        public Builder actions(String key, Function<Action.Builder, ObjectBuilder<Action>> fn) {
            return this.actions(Collections.singletonMap(key, fn.apply(new Action.Builder()).build()));
        }

        public Builder putActions(String key, Function<Action.Builder, ObjectBuilder<Action>> fn) {
            return this.putActions(key, fn.apply(new Action.Builder()).build());
        }

        public Builder condition(@Nullable Condition value) {
            this.condition = value;
            return this;
        }

        public Builder condition(Function<Condition.Builder, ObjectBuilder<Condition>> fn) {
            return this.condition(fn.apply(new Condition.Builder()).build());
        }

        public Builder input(@Nullable Input value) {
            this.input = value;
            return this;
        }

        public Builder input(Function<Input.Builder, ObjectBuilder<Input>> fn) {
            return this.input(fn.apply(new Input.Builder()).build());
        }

        public Builder metadata(@Nullable Map<String, JsonData> value) {
            this.metadata = value;
            return this;
        }

        public Builder putMetadata(String key, JsonData value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, JsonData>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder throttlePeriod(@Nullable String value) {
            this.throttlePeriod = value;
            return this;
        }

        public Builder transform(@Nullable Transform value) {
            this.transform = value;
            return this;
        }

        public Builder transform(Function<Transform.Builder, ObjectBuilder<Transform>> fn) {
            return this.transform(fn.apply(new Transform.Builder()).build());
        }

        public Builder trigger(@Nullable Trigger value) {
            this.trigger = value;
            return this;
        }

        public Builder trigger(Function<Trigger.Builder, ObjectBuilder<Trigger>> fn) {
            return this.trigger(fn.apply(new Trigger.Builder()).build());
        }

        @Override
        public PutWatchRequest build() {
            return new PutWatchRequest(this);
        }
    }
}

