/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.ExecutionResultAction;
import co.elastic.clients.elasticsearch.watcher.ExecutionResultCondition;
import co.elastic.clients.elasticsearch.watcher.ExecutionResultInput;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ExecutionResult
implements JsonpSerializable {
    private final List<ExecutionResultAction> actions;
    private final ExecutionResultCondition condition;
    private final int executionDuration;
    private final String executionTime;
    private final ExecutionResultInput input;
    public static final JsonpDeserializer<ExecutionResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExecutionResult::setupExecutionResultDeserializer, Builder::build);

    public ExecutionResult(Builder builder) {
        this.actions = ModelTypeHelper.unmodifiableNonNull(builder.actions, "actions");
        this.condition = Objects.requireNonNull(builder.condition, "condition");
        this.executionDuration = Objects.requireNonNull(builder.executionDuration, "execution_duration");
        this.executionTime = Objects.requireNonNull(builder.executionTime, "execution_time");
        this.input = Objects.requireNonNull(builder.input, "input");
    }

    public ExecutionResult(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<ExecutionResultAction> actions() {
        return this.actions;
    }

    public ExecutionResultCondition condition() {
        return this.condition;
    }

    public int executionDuration() {
        return this.executionDuration;
    }

    public String executionTime() {
        return this.executionTime;
    }

    public ExecutionResultInput input() {
        return this.input;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("actions");
        generator.writeStartArray();
        for (ExecutionResultAction item0 : this.actions) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("condition");
        this.condition.serialize(generator, mapper);
        generator.writeKey("execution_duration");
        generator.write(this.executionDuration);
        generator.writeKey("execution_time");
        generator.write(this.executionTime);
        generator.writeKey("input");
        this.input.serialize(generator, mapper);
    }

    protected static void setupExecutionResultDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::actions, JsonpDeserializer.arrayDeserializer(ExecutionResultAction._DESERIALIZER), "actions", new String[0]);
        op.add(Builder::condition, ExecutionResultCondition._DESERIALIZER, "condition", new String[0]);
        op.add(Builder::executionDuration, JsonpDeserializer.integerDeserializer(), "execution_duration", new String[0]);
        op.add(Builder::executionTime, JsonpDeserializer.stringDeserializer(), "execution_time", new String[0]);
        op.add(Builder::input, ExecutionResultInput._DESERIALIZER, "input", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ExecutionResult> {
        private List<ExecutionResultAction> actions;
        private ExecutionResultCondition condition;
        private Integer executionDuration;
        private String executionTime;
        private ExecutionResultInput input;

        public Builder actions(List<ExecutionResultAction> value) {
            this.actions = value;
            return this;
        }

        public Builder actions(ExecutionResultAction ... value) {
            this.actions = Arrays.asList(value);
            return this;
        }

        public Builder addActions(ExecutionResultAction value) {
            if (this.actions == null) {
                this.actions = new ArrayList<ExecutionResultAction>();
            }
            this.actions.add(value);
            return this;
        }

        public Builder actions(Function<ExecutionResultAction.Builder, ObjectBuilder<ExecutionResultAction>> fn) {
            return this.actions(fn.apply(new ExecutionResultAction.Builder()).build());
        }

        public Builder addActions(Function<ExecutionResultAction.Builder, ObjectBuilder<ExecutionResultAction>> fn) {
            return this.addActions(fn.apply(new ExecutionResultAction.Builder()).build());
        }

        public Builder condition(ExecutionResultCondition value) {
            this.condition = value;
            return this;
        }

        public Builder condition(Function<ExecutionResultCondition.Builder, ObjectBuilder<ExecutionResultCondition>> fn) {
            return this.condition(fn.apply(new ExecutionResultCondition.Builder()).build());
        }

        public Builder executionDuration(int value) {
            this.executionDuration = value;
            return this;
        }

        public Builder executionTime(String value) {
            this.executionTime = value;
            return this;
        }

        public Builder input(ExecutionResultInput value) {
            this.input = value;
            return this;
        }

        public Builder input(Function<ExecutionResultInput.Builder, ObjectBuilder<ExecutionResultInput>> fn) {
            return this.input(fn.apply(new ExecutionResultInput.Builder()).build());
        }

        @Override
        public ExecutionResult build() {
            return new ExecutionResult(this);
        }
    }
}

