/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.watcher.DeactivateWatchResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;

public final class DeactivateWatchRequest
extends RequestBase {
    private final String watchId;
    public static final Endpoint<DeactivateWatchRequest, DeactivateWatchResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DeactivateWatchRequest, DeactivateWatchResponse>(request -> "PUT", request -> {
        boolean _watchId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_watcher");
            buf.append("/watch");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.watchId, buf);
            buf.append("/_deactivate");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, DeactivateWatchResponse._DESERIALIZER);

    public DeactivateWatchRequest(Builder builder) {
        this.watchId = Objects.requireNonNull(builder.watchId, "watch_id");
    }

    public DeactivateWatchRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String watchId() {
        return this.watchId;
    }

    public static class Builder
    implements ObjectBuilder<DeactivateWatchRequest> {
        private String watchId;

        public Builder watchId(String value) {
            this.watchId = value;
            return this;
        }

        @Override
        public DeactivateWatchRequest build() {
            return new DeactivateWatchRequest(this);
        }
    }
}

