/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.AlwaysCondition;
import co.elastic.clients.elasticsearch.watcher.ArrayCompareCondition;
import co.elastic.clients.elasticsearch.watcher.CompareCondition;
import co.elastic.clients.elasticsearch.watcher.ConditionVariant;
import co.elastic.clients.elasticsearch.watcher.NeverCondition;
import co.elastic.clients.elasticsearch.watcher.ScriptCondition;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class Condition
implements TaggedUnion<Object>,
JsonpSerializable {
    public static final String ALWAYS = "always";
    public static final String ARRAY_COMPARE = "array_compare";
    public static final String COMPARE = "compare";
    public static final String NEVER = "never";
    public static final String SCRIPT = "script";
    private final String _type;
    private final Object _value;
    public static final JsonpDeserializer<Condition> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, Condition::setupConditionDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public Object _get() {
        return this._value;
    }

    public Condition(ConditionVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    public <T extends ConditionVariant> Condition(ObjectBuilder<T> builder) {
        this((ConditionVariant)builder.build());
    }

    private Condition(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public Condition(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public AlwaysCondition always() {
        return (AlwaysCondition)TaggedUnionUtils.get(this, ALWAYS);
    }

    public ArrayCompareCondition arrayCompare() {
        return (ArrayCompareCondition)TaggedUnionUtils.get(this, ARRAY_COMPARE);
    }

    public CompareCondition compare() {
        return (CompareCondition)TaggedUnionUtils.get(this, COMPARE);
    }

    public NeverCondition never() {
        return (NeverCondition)TaggedUnionUtils.get(this, NEVER);
    }

    public ScriptCondition script() {
        return (ScriptCondition)TaggedUnionUtils.get(this, SCRIPT);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._type);
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupConditionDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::always, AlwaysCondition._DESERIALIZER, ALWAYS, new String[0]);
        op.add(Builder::arrayCompare, ArrayCompareCondition._DESERIALIZER, ARRAY_COMPARE, new String[0]);
        op.add(Builder::compare, CompareCondition._DESERIALIZER, COMPARE, new String[0]);
        op.add(Builder::never, NeverCondition._DESERIALIZER, NEVER, new String[0]);
        op.add(Builder::script, ScriptCondition._DESERIALIZER, SCRIPT, new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Condition> {
        private String _type;
        private Object _value;

        public Builder always(AlwaysCondition v) {
            this._type = Condition.ALWAYS;
            this._value = v;
            return this;
        }

        public Builder always(Function<AlwaysCondition.Builder, ObjectBuilder<AlwaysCondition>> f) {
            return this.always(f.apply(new AlwaysCondition.Builder()).build());
        }

        public Builder arrayCompare(ArrayCompareCondition v) {
            this._type = Condition.ARRAY_COMPARE;
            this._value = v;
            return this;
        }

        public Builder arrayCompare(Function<ArrayCompareCondition.Builder, ObjectBuilder<ArrayCompareCondition>> f) {
            return this.arrayCompare(f.apply(new ArrayCompareCondition.Builder()).build());
        }

        public Builder compare(CompareCondition v) {
            this._type = Condition.COMPARE;
            this._value = v;
            return this;
        }

        public Builder compare(Function<CompareCondition.Builder, ObjectBuilder<CompareCondition>> f) {
            return this.compare(f.apply(new CompareCondition.Builder()).build());
        }

        public Builder never(NeverCondition v) {
            this._type = Condition.NEVER;
            this._value = v;
            return this;
        }

        public Builder never(Function<NeverCondition.Builder, ObjectBuilder<NeverCondition>> f) {
            return this.never(f.apply(new NeverCondition.Builder()).build());
        }

        public Builder script(ScriptCondition v) {
            this._type = Condition.SCRIPT;
            this._value = v;
            return this;
        }

        public Builder script(Function<ScriptCondition.Builder, ObjectBuilder<ScriptCondition>> f) {
            return this.script(f.apply(new ScriptCondition.Builder()).build());
        }

        @Override
        public Condition build() {
            return new Condition(this);
        }
    }
}

