/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.ActionStatus;
import co.elastic.clients.elasticsearch.watcher.ActivationState;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ActivationStatus
implements JsonpSerializable {
    private final Map<String, ActionStatus> actions;
    private final ActivationState state;
    private final long version;
    public static final JsonpDeserializer<ActivationStatus> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ActivationStatus::setupActivationStatusDeserializer, Builder::build);

    public ActivationStatus(Builder builder) {
        this.actions = ModelTypeHelper.unmodifiableNonNull(builder.actions, "actions");
        this.state = Objects.requireNonNull(builder.state, "state");
        this.version = Objects.requireNonNull(builder.version, "version");
    }

    public ActivationStatus(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, ActionStatus> actions() {
        return this.actions;
    }

    public ActivationState state() {
        return this.state;
    }

    public long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("actions");
        generator.writeStartObject();
        for (Map.Entry<String, ActionStatus> item0 : this.actions.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("state");
        this.state.serialize(generator, mapper);
        generator.writeKey("version");
        generator.write(this.version);
    }

    protected static void setupActivationStatusDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::actions, JsonpDeserializer.stringMapDeserializer(ActionStatus._DESERIALIZER), "actions", new String[0]);
        op.add(Builder::state, ActivationState._DESERIALIZER, "state", new String[0]);
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ActivationStatus> {
        private Map<String, ActionStatus> actions;
        private ActivationState state;
        private Long version;

        public Builder actions(Map<String, ActionStatus> value) {
            this.actions = value;
            return this;
        }

        public Builder putActions(String key, ActionStatus value) {
            if (this.actions == null) {
                this.actions = new HashMap<String, ActionStatus>();
            }
            this.actions.put(key, value);
            return this;
        }

        public Builder actions(String key, Function<ActionStatus.Builder, ObjectBuilder<ActionStatus>> fn) {
            return this.actions(Collections.singletonMap(key, fn.apply(new ActionStatus.Builder()).build()));
        }

        public Builder putActions(String key, Function<ActionStatus.Builder, ObjectBuilder<ActionStatus>> fn) {
            return this.putActions(key, fn.apply(new ActionStatus.Builder()).build());
        }

        public Builder state(ActivationState value) {
            this.state = value;
            return this;
        }

        public Builder state(Function<ActivationState.Builder, ObjectBuilder<ActivationState>> fn) {
            return this.state(fn.apply(new ActivationState.Builder()).build());
        }

        public Builder version(long value) {
            this.version = value;
            return this;
        }

        @Override
        public ActivationStatus build() {
            return new ActivationStatus(this);
        }
    }
}

