/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform.get_transform_stats;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class TransformProgress
implements JsonpSerializable {
    private final long docsIndexed;
    private final long docsProcessed;
    private final long docsRemaining;
    private final double percentComplete;
    private final long totalDocs;
    public static final JsonpDeserializer<TransformProgress> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TransformProgress::setupTransformProgressDeserializer, Builder::build);

    public TransformProgress(Builder builder) {
        this.docsIndexed = Objects.requireNonNull(builder.docsIndexed, "docs_indexed");
        this.docsProcessed = Objects.requireNonNull(builder.docsProcessed, "docs_processed");
        this.docsRemaining = Objects.requireNonNull(builder.docsRemaining, "docs_remaining");
        this.percentComplete = Objects.requireNonNull(builder.percentComplete, "percent_complete");
        this.totalDocs = Objects.requireNonNull(builder.totalDocs, "total_docs");
    }

    public TransformProgress(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long docsIndexed() {
        return this.docsIndexed;
    }

    public long docsProcessed() {
        return this.docsProcessed;
    }

    public long docsRemaining() {
        return this.docsRemaining;
    }

    public double percentComplete() {
        return this.percentComplete;
    }

    public long totalDocs() {
        return this.totalDocs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("docs_indexed");
        generator.write(this.docsIndexed);
        generator.writeKey("docs_processed");
        generator.write(this.docsProcessed);
        generator.writeKey("docs_remaining");
        generator.write(this.docsRemaining);
        generator.writeKey("percent_complete");
        generator.write(this.percentComplete);
        generator.writeKey("total_docs");
        generator.write(this.totalDocs);
    }

    protected static void setupTransformProgressDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::docsIndexed, JsonpDeserializer.longDeserializer(), "docs_indexed", new String[0]);
        op.add(Builder::docsProcessed, JsonpDeserializer.longDeserializer(), "docs_processed", new String[0]);
        op.add(Builder::docsRemaining, JsonpDeserializer.longDeserializer(), "docs_remaining", new String[0]);
        op.add(Builder::percentComplete, JsonpDeserializer.doubleDeserializer(), "percent_complete", new String[0]);
        op.add(Builder::totalDocs, JsonpDeserializer.longDeserializer(), "total_docs", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TransformProgress> {
        private Long docsIndexed;
        private Long docsProcessed;
        private Long docsRemaining;
        private Double percentComplete;
        private Long totalDocs;

        public Builder docsIndexed(long value) {
            this.docsIndexed = value;
            return this;
        }

        public Builder docsProcessed(long value) {
            this.docsProcessed = value;
            return this;
        }

        public Builder docsRemaining(long value) {
            this.docsRemaining = value;
            return this;
        }

        public Builder percentComplete(double value) {
            this.percentComplete = value;
            return this;
        }

        public Builder totalDocs(long value) {
            this.totalDocs = value;
            return this;
        }

        @Override
        public TransformProgress build() {
            return new TransformProgress(this);
        }
    }
}

