/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform.get_transform_stats;

import co.elastic.clients.elasticsearch.transform.get_transform_stats.CheckpointStats;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Checkpointing
implements JsonpSerializable {
    private final long changesLastDetectedAt;
    @Nullable
    private final String changesLastDetectedAtDateTime;
    private final CheckpointStats last;
    @Nullable
    private final CheckpointStats next;
    @Nullable
    private final Long operationsBehind;
    public static final JsonpDeserializer<Checkpointing> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Checkpointing::setupCheckpointingDeserializer, Builder::build);

    public Checkpointing(Builder builder) {
        this.changesLastDetectedAt = Objects.requireNonNull(builder.changesLastDetectedAt, "changes_last_detected_at");
        this.changesLastDetectedAtDateTime = builder.changesLastDetectedAtDateTime;
        this.last = Objects.requireNonNull(builder.last, "last");
        this.next = builder.next;
        this.operationsBehind = builder.operationsBehind;
    }

    public Checkpointing(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long changesLastDetectedAt() {
        return this.changesLastDetectedAt;
    }

    @Nullable
    public String changesLastDetectedAtDateTime() {
        return this.changesLastDetectedAtDateTime;
    }

    public CheckpointStats last() {
        return this.last;
    }

    @Nullable
    public CheckpointStats next() {
        return this.next;
    }

    @Nullable
    public Long operationsBehind() {
        return this.operationsBehind;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("changes_last_detected_at");
        generator.write(this.changesLastDetectedAt);
        if (this.changesLastDetectedAtDateTime != null) {
            generator.writeKey("changes_last_detected_at_date_time");
            generator.write(this.changesLastDetectedAtDateTime);
        }
        generator.writeKey("last");
        this.last.serialize(generator, mapper);
        if (this.next != null) {
            generator.writeKey("next");
            this.next.serialize(generator, mapper);
        }
        if (this.operationsBehind != null) {
            generator.writeKey("operations_behind");
            generator.write(this.operationsBehind.longValue());
        }
    }

    protected static void setupCheckpointingDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::changesLastDetectedAt, JsonpDeserializer.longDeserializer(), "changes_last_detected_at", new String[0]);
        op.add(Builder::changesLastDetectedAtDateTime, JsonpDeserializer.stringDeserializer(), "changes_last_detected_at_date_time", new String[0]);
        op.add(Builder::last, CheckpointStats._DESERIALIZER, "last", new String[0]);
        op.add(Builder::next, CheckpointStats._DESERIALIZER, "next", new String[0]);
        op.add(Builder::operationsBehind, JsonpDeserializer.longDeserializer(), "operations_behind", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Checkpointing> {
        private Long changesLastDetectedAt;
        @Nullable
        private String changesLastDetectedAtDateTime;
        private CheckpointStats last;
        @Nullable
        private CheckpointStats next;
        @Nullable
        private Long operationsBehind;

        public Builder changesLastDetectedAt(long value) {
            this.changesLastDetectedAt = value;
            return this;
        }

        public Builder changesLastDetectedAtDateTime(@Nullable String value) {
            this.changesLastDetectedAtDateTime = value;
            return this;
        }

        public Builder last(CheckpointStats value) {
            this.last = value;
            return this;
        }

        public Builder last(Function<CheckpointStats.Builder, ObjectBuilder<CheckpointStats>> fn) {
            return this.last(fn.apply(new CheckpointStats.Builder()).build());
        }

        public Builder next(@Nullable CheckpointStats value) {
            this.next = value;
            return this;
        }

        public Builder next(Function<CheckpointStats.Builder, ObjectBuilder<CheckpointStats>> fn) {
            return this.next(fn.apply(new CheckpointStats.Builder()).build());
        }

        public Builder operationsBehind(@Nullable Long value) {
            this.operationsBehind = value;
            return this;
        }

        @Override
        public Checkpointing build() {
            return new Checkpointing(this);
        }
    }
}

