/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.transform.StopTransformResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class StopTransformRequest
extends RequestBase {
    private final String transformId;
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Boolean force;
    @Nullable
    private final String timeout;
    @Nullable
    private final Boolean waitForCheckpoint;
    @Nullable
    private final Boolean waitForCompletion;
    public static final Endpoint<StopTransformRequest, StopTransformResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<StopTransformRequest, StopTransformResponse>(request -> "POST", request -> {
        boolean _transformId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_transform");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.transformId, buf);
            buf.append("/_stop");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        if (request.force != null) {
            params.put("force", String.valueOf(request.force));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        if (request.waitForCheckpoint != null) {
            params.put("wait_for_checkpoint", String.valueOf(request.waitForCheckpoint));
        }
        if (request.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(request.waitForCompletion));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, StopTransformResponse._DESERIALIZER);

    public StopTransformRequest(Builder builder) {
        this.transformId = Objects.requireNonNull(builder.transformId, "transform_id");
        this.allowNoMatch = builder.allowNoMatch;
        this.force = builder.force;
        this.timeout = builder.timeout;
        this.waitForCheckpoint = builder.waitForCheckpoint;
        this.waitForCompletion = builder.waitForCompletion;
    }

    public StopTransformRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String transformId() {
        return this.transformId;
    }

    @Nullable
    public Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public Boolean force() {
        return this.force;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public Boolean waitForCheckpoint() {
        return this.waitForCheckpoint;
    }

    @Nullable
    public Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    public static class Builder
    implements ObjectBuilder<StopTransformRequest> {
        private String transformId;
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Boolean force;
        @Nullable
        private String timeout;
        @Nullable
        private Boolean waitForCheckpoint;
        @Nullable
        private Boolean waitForCompletion;

        public Builder transformId(String value) {
            this.transformId = value;
            return this;
        }

        public Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public Builder force(@Nullable Boolean value) {
            this.force = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder waitForCheckpoint(@Nullable Boolean value) {
            this.waitForCheckpoint = value;
            return this;
        }

        public Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        @Override
        public StopTransformRequest build() {
            return new StopTransformRequest(this);
        }
    }
}

