/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.base.ApiClient;
import co.elastic.clients.base.Transport;
import co.elastic.clients.elasticsearch.transform.DeleteTransformRequest;
import co.elastic.clients.elasticsearch.transform.DeleteTransformResponse;
import co.elastic.clients.elasticsearch.transform.GetTransformRequest;
import co.elastic.clients.elasticsearch.transform.GetTransformResponse;
import co.elastic.clients.elasticsearch.transform.GetTransformStatsRequest;
import co.elastic.clients.elasticsearch.transform.GetTransformStatsResponse;
import co.elastic.clients.elasticsearch.transform.PreviewTransformRequest;
import co.elastic.clients.elasticsearch.transform.PreviewTransformResponse;
import co.elastic.clients.elasticsearch.transform.PutTransformRequest;
import co.elastic.clients.elasticsearch.transform.PutTransformResponse;
import co.elastic.clients.elasticsearch.transform.StartTransformRequest;
import co.elastic.clients.elasticsearch.transform.StartTransformResponse;
import co.elastic.clients.elasticsearch.transform.StopTransformRequest;
import co.elastic.clients.elasticsearch.transform.StopTransformResponse;
import co.elastic.clients.elasticsearch.transform.UpdateTransformRequest;
import co.elastic.clients.elasticsearch.transform.UpdateTransformResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class ElasticsearchTransformAsyncClient
extends ApiClient {
    public ElasticsearchTransformAsyncClient(Transport transport) {
        super(transport);
    }

    public CompletableFuture<DeleteTransformResponse> deleteTransform(DeleteTransformRequest request) throws IOException {
        return this.transport.performRequestAsync(request, DeleteTransformRequest.ENDPOINT);
    }

    public final CompletableFuture<DeleteTransformResponse> deleteTransform(Function<DeleteTransformRequest.Builder, ObjectBuilder<DeleteTransformRequest>> fn) throws IOException {
        return this.deleteTransform(fn.apply(new DeleteTransformRequest.Builder()).build());
    }

    public CompletableFuture<GetTransformResponse> getTransform(GetTransformRequest request) throws IOException {
        return this.transport.performRequestAsync(request, GetTransformRequest.ENDPOINT);
    }

    public final CompletableFuture<GetTransformResponse> getTransform(Function<GetTransformRequest.Builder, ObjectBuilder<GetTransformRequest>> fn) throws IOException {
        return this.getTransform(fn.apply(new GetTransformRequest.Builder()).build());
    }

    public CompletableFuture<GetTransformStatsResponse> getTransformStats(GetTransformStatsRequest request) throws IOException {
        return this.transport.performRequestAsync(request, GetTransformStatsRequest.ENDPOINT);
    }

    public final CompletableFuture<GetTransformStatsResponse> getTransformStats(Function<GetTransformStatsRequest.Builder, ObjectBuilder<GetTransformStatsRequest>> fn) throws IOException {
        return this.getTransformStats(fn.apply(new GetTransformStatsRequest.Builder()).build());
    }

    public <TTransform> CompletableFuture<PreviewTransformResponse<TTransform>> previewTransform(PreviewTransformRequest request, Class<TTransform> tTransformClass) throws IOException {
        return this.transport.performRequestAsync(request, PreviewTransformRequest.createPreviewTransformEndpoint(this.getDeserializer(tTransformClass)));
    }

    public final <TTransform> CompletableFuture<PreviewTransformResponse<TTransform>> previewTransform(Function<PreviewTransformRequest.Builder, ObjectBuilder<PreviewTransformRequest>> fn, Class<TTransform> tTransformClass) throws IOException {
        return this.previewTransform(fn.apply(new PreviewTransformRequest.Builder()).build(), tTransformClass);
    }

    public CompletableFuture<PutTransformResponse> putTransform(PutTransformRequest request) throws IOException {
        return this.transport.performRequestAsync(request, PutTransformRequest.ENDPOINT);
    }

    public final CompletableFuture<PutTransformResponse> putTransform(Function<PutTransformRequest.Builder, ObjectBuilder<PutTransformRequest>> fn) throws IOException {
        return this.putTransform(fn.apply(new PutTransformRequest.Builder()).build());
    }

    public CompletableFuture<StartTransformResponse> startTransform(StartTransformRequest request) throws IOException {
        return this.transport.performRequestAsync(request, StartTransformRequest.ENDPOINT);
    }

    public final CompletableFuture<StartTransformResponse> startTransform(Function<StartTransformRequest.Builder, ObjectBuilder<StartTransformRequest>> fn) throws IOException {
        return this.startTransform(fn.apply(new StartTransformRequest.Builder()).build());
    }

    public CompletableFuture<StopTransformResponse> stopTransform(StopTransformRequest request) throws IOException {
        return this.transport.performRequestAsync(request, StopTransformRequest.ENDPOINT);
    }

    public final CompletableFuture<StopTransformResponse> stopTransform(Function<StopTransformRequest.Builder, ObjectBuilder<StopTransformRequest>> fn) throws IOException {
        return this.stopTransform(fn.apply(new StopTransformRequest.Builder()).build());
    }

    public CompletableFuture<UpdateTransformResponse> updateTransform(UpdateTransformRequest request) throws IOException {
        return this.transport.performRequestAsync(request, UpdateTransformRequest.ENDPOINT);
    }

    public final CompletableFuture<UpdateTransformResponse> updateTransform(Function<UpdateTransformRequest.Builder, ObjectBuilder<UpdateTransformRequest>> fn) throws IOException {
        return this.updateTransform(fn.apply(new UpdateTransformRequest.Builder()).build());
    }
}

