/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.tasks;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.tasks.GetResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class GetRequest
extends RequestBase {
    private final String taskId;
    @Nullable
    private final String timeout;
    @Nullable
    private final Boolean waitForCompletion;
    public static final Endpoint<GetRequest, GetResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetRequest, GetResponse>(request -> "GET", request -> {
        boolean _taskId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_tasks");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        if (request.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(request.waitForCompletion));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetResponse._DESERIALIZER);

    public GetRequest(Builder builder) {
        this.taskId = Objects.requireNonNull(builder.taskId, "task_id");
        this.timeout = builder.timeout;
        this.waitForCompletion = builder.waitForCompletion;
    }

    public GetRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String taskId() {
        return this.taskId;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    public static class Builder
    implements ObjectBuilder<GetRequest> {
        private String taskId;
        @Nullable
        private String timeout;
        @Nullable
        private Boolean waitForCompletion;

        public Builder taskId(String value) {
            this.taskId = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        @Override
        public GetRequest build() {
            return new GetRequest(this);
        }
    }
}

