/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.sql;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class TranslateResponse
implements JsonpSerializable {
    private final long size;
    private final JsonValue source;
    private final List<Map<String, String>> fields;
    private final List<JsonValue> sort;
    public static final JsonpDeserializer<TranslateResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TranslateResponse::setupTranslateResponseDeserializer, Builder::build);

    public TranslateResponse(Builder builder) {
        this.size = Objects.requireNonNull(builder.size, "size");
        this.source = Objects.requireNonNull(builder.source, "_source");
        this.fields = ModelTypeHelper.unmodifiableNonNull(builder.fields, "fields");
        this.sort = ModelTypeHelper.unmodifiableNonNull(builder.sort, "sort");
    }

    public TranslateResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long size() {
        return this.size;
    }

    public JsonValue source() {
        return this.source;
    }

    public List<Map<String, String>> fields() {
        return this.fields;
    }

    public List<JsonValue> sort() {
        return this.sort;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("size");
        generator.write(this.size);
        generator.writeKey("_source");
        generator.write(this.source);
        generator.writeKey("fields");
        generator.writeStartArray();
        for (Map<String, String> map : this.fields) {
            generator.writeStartObject();
            for (Map.Entry<String, String> item1 : map.entrySet()) {
                generator.writeKey(item1.getKey());
                generator.write(item1.getValue());
            }
            generator.writeEnd();
        }
        generator.writeEnd();
        generator.writeKey("sort");
        generator.writeStartArray();
        for (JsonValue jsonValue : this.sort) {
            generator.write(jsonValue);
        }
        generator.writeEnd();
    }

    protected static void setupTranslateResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::size, JsonpDeserializer.longDeserializer(), "size", new String[0]);
        op.add(Builder::source, JsonpDeserializer.jsonValueDeserializer(), "_source", new String[0]);
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer())), "fields", new String[0]);
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.jsonValueDeserializer()), "sort", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TranslateResponse> {
        private Long size;
        private JsonValue source;
        private List<Map<String, String>> fields;
        private List<JsonValue> sort;

        public Builder size(long value) {
            this.size = value;
            return this;
        }

        public Builder source(JsonValue value) {
            this.source = value;
            return this;
        }

        public Builder fields(List<Map<String, String>> value) {
            this.fields = value;
            return this;
        }

        public Builder fields(Map<String, String> ... value) {
            this.fields = Arrays.asList(value);
            return this;
        }

        public Builder addFields(Map<String, String> value) {
            if (this.fields == null) {
                this.fields = new ArrayList<Map<String, String>>();
            }
            this.fields.add(value);
            return this;
        }

        public Builder sort(List<JsonValue> value) {
            this.sort = value;
            return this;
        }

        public Builder sort(JsonValue ... value) {
            this.sort = Arrays.asList(value);
            return this;
        }

        public Builder addSort(JsonValue value) {
            if (this.sort == null) {
                this.sort = new ArrayList<JsonValue>();
            }
            this.sort.add(value);
            return this;
        }

        @Override
        public TranslateResponse build() {
            return new TranslateResponse(this);
        }
    }
}

