/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.sql;

import co.elastic.clients.elasticsearch.sql.query.Column;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class QueryResponse
implements JsonpSerializable {
    @Nullable
    private final List<Column> columns;
    @Nullable
    private final String cursor;
    private final List<List<JsonData>> rows;
    public static final JsonpDeserializer<QueryResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryResponse::setupQueryResponseDeserializer, Builder::build);

    public QueryResponse(Builder builder) {
        this.columns = ModelTypeHelper.unmodifiable(builder.columns);
        this.cursor = builder.cursor;
        this.rows = ModelTypeHelper.unmodifiableNonNull(builder.rows, "rows");
    }

    public QueryResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<Column> columns() {
        return this.columns;
    }

    @Nullable
    public String cursor() {
        return this.cursor;
    }

    public List<List<JsonData>> rows() {
        return this.rows;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.columns != null) {
            generator.writeKey("columns");
            generator.writeStartArray();
            for (Column column : this.columns) {
                column.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.cursor != null) {
            generator.writeKey("cursor");
            generator.write(this.cursor);
        }
        generator.writeKey("rows");
        generator.writeStartArray();
        for (List list : this.rows) {
            generator.writeStartArray();
            for (JsonData item1 : list) {
                item1.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeEnd();
    }

    protected static void setupQueryResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::columns, JsonpDeserializer.arrayDeserializer(Column._DESERIALIZER), "columns", new String[0]);
        op.add(Builder::cursor, JsonpDeserializer.stringDeserializer(), "cursor", new String[0]);
        op.add(Builder::rows, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.arrayDeserializer(JsonData._DESERIALIZER)), "rows", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<QueryResponse> {
        @Nullable
        private List<Column> columns;
        @Nullable
        private String cursor;
        private List<List<JsonData>> rows;

        public Builder columns(@Nullable List<Column> value) {
            this.columns = value;
            return this;
        }

        public Builder columns(Column ... value) {
            this.columns = Arrays.asList(value);
            return this;
        }

        public Builder addColumns(Column value) {
            if (this.columns == null) {
                this.columns = new ArrayList<Column>();
            }
            this.columns.add(value);
            return this;
        }

        public Builder columns(Function<Column.Builder, ObjectBuilder<Column>> fn) {
            return this.columns(fn.apply(new Column.Builder()).build());
        }

        public Builder addColumns(Function<Column.Builder, ObjectBuilder<Column>> fn) {
            return this.addColumns(fn.apply(new Column.Builder()).build());
        }

        public Builder cursor(@Nullable String value) {
            this.cursor = value;
            return this;
        }

        public Builder rows(List<List<JsonData>> value) {
            this.rows = value;
            return this;
        }

        public Builder rows(List<JsonData> ... value) {
            this.rows = Arrays.asList(value);
            return this;
        }

        public Builder addRows(List<JsonData> value) {
            if (this.rows == null) {
                this.rows = new ArrayList<List<JsonData>>();
            }
            this.rows.add(value);
            return this;
        }

        @Override
        public QueryResponse build() {
            return new QueryResponse(this);
        }
    }
}

